;3d Maze - with minigames
;clear scores etc at start of game                                               - done
;timer                                                                           - done
;opening music/title
;add keypress to stop titlemusic routine
;count minigames - to give total played to get 10000 points                      - done
;random spawn exit                                                               - done
;give total score (number of minigames played)                                   - done
;ending                                                                          - done
;clear board of minigames / etc                                                  - done
;allow practice of minigames?                                                    - done
;indicate when new minigames (increaseminigames) is doing it's thing
;map?                                                                            - done
;key debounce for rotate                                                         - done
;update scores after game, prettily                                              - done
;random spawn point                                                              - done limited to top of maze
;random spawn minigame routine                                                   - done
;to do - seed the random number r-seed from 'frames' when you press start        - done
;to do - new map                                                                 - done
;edge case - snake game where two black panels are adjacent, can escape maze!    - done
;easy mode

ORG 32768

                  jp          firstStart

                  jp          SCRATCHATTR

magicdoor:        defb  7          ; colour of the minigame door  [7=white,or 0 black]
strobedoor:       defb  1          ; exit door colour, runs from blue to white
exitingmazeflag:  defb  0          ; used to check if we are exiting the maze now

score:            defw  0
minigamesplayed:  defb  0          ; number of games played
mapuse:           defb  0          ; number of times map is consulted

leftcol           defb  2           ; starting colours of walls
frontcol          defb  6
rightcol          defb  4
backcol           defb  3
topcol            defb  5
botcol            defb  1


ycoord            defb  2           ; player position
xcoord            defb  3
aheadofus         defb  0,1         ; direction we're moving/looking in
leftofus          defb  -1,0        ; used for checking
rightofus         defb  1,0         ; used for checking
behindus          defb  0,-1      ; used for rotating purposes
depthcount        defb  5           ; used to check each position

minigametable:
                        defw  minigame1   ; worm
                        defw  minigame4   ; flappy
                        defw  minigame3   ; snake
                        defw  minigame2   ; city

minigamechoice: defb    0
                  defb  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 ; maze edge - used for edge effect testing when placing minigames nothing else
maze:
                  defb  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1  ;1
                  defb  1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,0,1,0,1,0,1,1,1,0,0,0,1  ;2
                  defb  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1  ;3
                  defb  1,0,1,0,1,1,1,1,1,1,1,0,1,0,1,1,0,1,0,1,1,1,1,1,0,1,0,1,0,1,0,1  ;4
                  defb  1,0,1,0,1,0,0,0,1,0,1,0,1,0,1,1,0,1,0,1,0,0,0,1,0,1,0,1,0,1,0,1  ;5
                  defb  1,0,1,0,1,0,1,0,0,0,1,0,1,0,1,1,0,1,1,1,0,1,0,1,1,1,1,1,0,1,0,1  ;6
                  defb  1,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1  ;7
                  defb  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1  ;8
                  defb  1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1  ;9
                  defb  1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,0,1,0,1,0,0,0,1,1,1,0,1  ;10
                  defb  1,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1  ;11
                  defb  1,0,1,0,1,1,1,1,1,1,1,0,0,0,1,1,0,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1  ;12
                  defb  1,0,1,0,1,0,0,0,0,0,1,0,1,0,1,1,0,1,0,1,0,0,0,1,0,1,0,1,1,1,0,1  ;13
                  defb  1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,1,0,1,0,1,0,1,0,1,1,1,1,1,1,1,0,1  ;14
                  defb  1,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,1  ;15
                  defb  1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1  ;16
                  defb  1,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,1  ;17
                  defb  1,0,1,1,1,0,1,0,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,1  ;18
                  defb  1,0,1,0,1,0,1,0,1,1,0,1,1,1,1,1,0,1,1,1,0,0,0,1,0,0,0,0,0,1,0,1  ;19
                  defb  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,0,1  ;20
                  defb  1,0,1,0,1,0,1,1,1,1,1,0,1,1,0,1,0,1,1,1,0,0,0,0,0,1,0,0,0,1,0,1  ;21
                  defb  1,0,1,0,1,0,1,1,1,1,1,0,1,1,0,1,0,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1  ;22
                  defb  1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,1  ;23
mazebreak1:       defb  1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1  ;24  map could end here and all fit on screen
mazebreak2:       defb  1,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,1,1 ; for maze edge - muat all be ones
                  defb  4,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4 ; Unused maze
                  defb  1,0,4,1,0,0,0,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,0,1 ; Unused maze
                  defb  4,0,1,1,0,0,0,1,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,4,1,0,4 ; Unused maze              ; deliberately uses arrangement of 'spent' panels that will not render correctly.
                  defb  1,0,4,1,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,4,4,0,0,4,4,0,1 ;
                  defb  4,0,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,1,0,4 ;
                  defb  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1 ;
                  defb  1,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1 ;
                  ;STARTPOS2,3  ^ here    , facing right

gameflags:
                  defb  0,0,0,0                 ; flags for if there is a special door to the left/right/above/below you

practiceflag:     defb  0                       ; is it a practice mini game, if 1=YES (no score, etc)

startmessage:
            ;DEFB "ATTR=MAZE=",255
            DEFB "I:NFO     SPACESTART",255
infomessage:

            DEFB "QUEST:EXITMAZE;QUICK",255
            DEFB "KEYS:QAOPMSPACE1:MAP",255
            DEFB "BLACKPANELHIDESAGAME",255
            DEFB "WHITEPANELMEANSSPENT",255
            DEFB "BRDERSHOWSHINTSABOUT",255
            DEFB "WHEREGAMESCANBEFOUND",255
            DEFB "SCORE10000USINGGAMES",255
            DEFB "WHICHOPENSMAGICPANEL",255
            DEFB "MAGICPANELEXITSQUEST",255
            DEFB "                ;;OR",255
            DEFB "CHEATUSINGMENU:12345",255
            DEFB "LEARNMINI=GAMESPRESS",255
            DEFB "1:DDG2:BMB3:SNK4:FLP",255
            DEFB "USE:5EASY==MODEONOFF",255
            DEFB "3D    ATTR MAZE GAME",255
            DEFB "BY    ANDYJENK=INSON",255
            DEFB "FOR        WOOT 2022",255


helpmessage: defb "INFO"
menumessage: defb "MENU"
playmessage: defb "PLAY"
findmessage: defb "FIND"
easymessage: defb "EASY"
hardmessage: defb "HARD"
            ;DEFB "WOOT==2022",255
            ;defb  0,96,0,96,0               ; : colon
            ;defb  0,0,0,0,80                ; ; elipsis
            ;defb  48,95,192,96,48           ; < less then
            ;defb  0,0,240,0,0               ; = equals - used as hyphen
            ;defb  192,96,48,96,192          ; > greater than
            ;defb  249,144,32,0,32           ; ? question mark


moreinfo:
                call  squidgebleep
                ld    hl,helpmessage
                call  printdiagword
                call  prinrhtenumber_word

                ld    hl,infomessage
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                call  nextinfo
                jr    Start
nextinfo:
                ld    de,$0202
                ld    (bigtextcoords),de
                call  bigtext
                inc   hl
                call  keydebounce
                call  waitforkeypress
                call  keydebounce

                ret



firstStart:                                                                                         ; frontend

                                                                                                    ; store screen$
                ld    de,END_OF_GAME                                                                ; loading screen stored here                                                                                                                                                                                                        ; keydebounce
                ld    hl,$4000                                                                      ; screen
                ld    bc,6144+768                                                                   ; pixels+attr
                ldir
                call  set_up_the_screen                                                             ; one time only - set up the screen
subsequentStart:
                                                                                                   ; recall SCREEN$
                ld    hl,END_OF_GAME                                                               ; loading screen stored here                                                                                                                                                                                                        ; keydebounce
                ld    de,$4000
                ld    bc,6144+768
                ldir                                                                                ; recall screen to screen
                call  playopeningtheme                                                              ; this has on-key return

                call  keydebounce                                                                   ; make sure no accidental keypress

Start:                                                                                              ; after info/newgame etc

backtomenu:                                                                                          ; eg. from practicegame
                call  clsblack  ; black on black screen
                ld    a,1*8+1
                ld    hl,$5800
                ld    bc,$1818
                call  colourbox       ; draw a blue box     24x24
                call  clear_mini_screen

                ld    hl,menumessage
                call  printdiagword
                call  prinrhtenumber_word

                ld    a,1
                ld    (practiceflag),a    ; assume practice game, this will be reset in real game

                ld    de,$0202
                ld    (bigtextcoords),de
                ld    hl,startmessage
                call  bigtext


waitfor1234spaceM:                         ; or I
                ld bc,$f7fe                ; numbers
                in a,(c)
                and %11111
                cp  %11111                ; 1,2,3,4,5 have been pressed
                jr  nz,practicegame       ; it's practice game time, or cheat mode 5

                ld bc,32766               ; B, N, M, Symbol Shift, Space
                in a,(c)
                cpl                       ;
                and %101                  ; consider M and Space
                jp     nz,Start_game      ; if it's being pressed

                ld bc,57342               ; POIUY
                in a,(c)
                cpl                       ;
                and    %100               ; consider I
                jp     nz,moreinfo        ; if it's being pressed
                jr     waitfor1234spaceM  ; wait for one of the keys to be pressed

easymode:                                    ; called when 5 is pressed on the menu, makes the minigames easy/hard

                ld    hl,easymod1
                ld    a,(hl)
                or    a                      ; is it currently a NOP   ?
                jr    z,makeeasy
                jr    makehard
makeeasy:
                ld    hl,easymessage         ; print easymessage
                call  printdiagword
                call  prinrhtenumber_word
                ld    a,$76                  ; this is the opcode for HALT
                ld    (easymod1),a           ; add a HALT to each minigame
                ld    (easymod2),a
                ld    (easymod3),a
                ld    (easymod4),a
                ld    de,5000                ; easier target score
                ld    (easymod5+1),de
                ld    de,4900
                ld    (easymod7+1),de
               ; ld    (easymod6+1),de
                jr    exiteasyswap
makehard:
                ld    hl,hardmessage         ; print easymessage
                call  printdiagword
                call  prinrhtenumber_word
                xor   a
                ld    (easymod1),a
                ld    (easymod2),a
                ld    (easymod3),a
                ld    (easymod4),a
                ld    de,9999                ; normal target score to exit
                ld    (easymod5+1),de
               ; ld    (easymod6+1),de
                ld    de,9900
                ld    (easymod7+1),de
exiteasyswap:
                call   keydebounce
                jr     waitfor1234spaceM



practicegame:
                push  af


                ld hl,SCRATCHATTR                         ; fill scratchattrwith blue for flappy bird etc
                ld de,SCRATCHATTR+1
                ld (hl),1+8
                ld bc,767
                ldir

                call  squidgebleep

                pop   af          ; retrieve the keypresses
                bit   4,a         ; is 5 being pressed
                jp    Z,easymode
                push  af          ; store the keypresses

                ld    a,1*8+1
                ld    hl,$5800
                ld    bc,$1818
                call  colourbox       ; draw a blue box     24x24
                ld    a,(23672)
                ld    (r_seed),a      ;seed the random number generator
                pop   af

                rra                       ; 1                          ; practice minigames
                jr     c,notmg1
                call   minigame1     ; if it's being pressed
                jr     finishedprac
notmg1:         rra                       ; 2
                jr     c,notmg2
                call   minigame2     ; if it's being pressed
                jr     finishedprac
notmg2:
                rra                       ; 3
                jr     c,notmg3
                call   minigame3     ; if it's being pressed
                jr     finishedprac
notmg3:         rra                       ; 4
                jr     c,notmg4
                call   minigame4     ; if it's being pressed
                jr     finishedprac
notmg4:
finishedprac:   ;reset menu etc for menu


                call   keydebounce   ; wait for no keys to be pressed
                call   waitforkeypress
                call   keydebounce   ; wait for no keys to be pressed
                jp    backtomenu

Start_game:     ; start a proper game here


                ld    hl,playmessage
                call  printdiagword
                call  prinrhtenumber_word


                call   clear_all_panels     ; clears all panels from maze


                ld      a,(23672)
                ld     (r_seed),a      ;seed the random number generator

                ld      hl,0                            ; clear score
                ld      (23673),hl                      ; frames counter
                ld      (score),hl
                ld     a,1
                ld     hl,mazebreak1+1                    ; fix maze, if it's been broken by cheat mode
                ld     (hl),a
                ld     hl,mazebreak2+1
                ld     (hl),a
                xor     a
                ld      (23672),a                       ; frames counter
                ld      (minigamesplayed),a             ; clear number of minigames played
                ld      (mapuse),a                      ; clear number of times map has been used
                ld      (practiceflag),a                ; reset the practice flag, this is a real game
                ld      (exitingmazeflag),a             ; reset the exiting the game flag


                ld     hl,startjingle
                call   playjingle            ; play opening tune

                call  rand_8                              ; start with a random minigame
                and   %110  ; 0,2,4 or 6
                ld    (minigamechoice),a                  ; store the choice

                call  randomplayerpos

                call randomdoorpos8                                     ; set up four minigames, initially
                ld     (hl),2       ; sets it to a MINIGAME             ; all in the top of the maze
                call randomdoorpos8
                ld     (hl),2       ; sets it to a MINIGAME
                call randomdoorpos8
                ld     (hl),2       ; sets it to a MINIGAME
                call randomdoorpos8
                ld     (hl),2       ; sets it to a MINIGAME

                  call  clsblack  ; black on black screen

;                  call  set_up_the_screen

                  call  drawtunnel    ; sets op the diagonals
                  call  colourcompass


          ;        call  fade_to_black

          ;        ld    hl,bigtext_message
          ;        call  bigtext
          ;        bg jr bg


                  ; draw tunnel from players viewpoint
loop:
                  call  setuptunnelcolour

                  call  drawview

                  halt
                  call  setupindicators
                  halt
                  call  border_stuff

                  halt

                  call  colourbuffertoscreen



       ld bc,57342         ; keyboard row POIUY
       in a,(c)            ; see what keys are pressed.
       rra                 ; outermost bit = key P.
       push af             ; remember the value.
       call nc,mpr         ; it's being pressed, move right.
       pop af              ; restore accumulator.
       rra                 ; next bit along (value 2) = key O.
       call nc,mpl         ; being pressed, so move left.

       ld bc,64510         ; keyboard row QWERT
       in a,(c)            ; see what keys are pressed.
       rra                 ; outermost bit = key Q.
       call nc,movef        ; it's being pressed, move forward

       ld bc,65022         ; keyboard row ASDFG
       in a,(c)            ; see what keys are pressed.
       rra                 ; outermost bit = key A.
       call nc,moveb       ; it's being pressed, move forward

       ld bc,32766         ; B, N, M, Symbol Shift, Space
       in a,(c)
       cpl                 ;
       and %101            ; consider M and Space
       call     nz,fire    ; if it's being pressed

       ld     bc,$f7fe     ; numbers 12345
       in     a,(c)
       rra                 ; 1
       call   nc,map       ; if it's being pressed

       ld     bc,$f7fe     ; numbers 12345
       in     a,(c)
       and    %11111
       cp     %11001       ; 2 and 3
       jr     nz,nocheat1  ; if it's NOT being pressed
easymod7:
       ld     hl,9900      ; get VERY close to finished - CHEAT MODE
       ld     (score),hl
       ld     hl,(score)
       call   display_HL
       jr     hanghere     ; skip other cheatmode
nocheat1:
       cp     %00111       ; 4 amd 5                   - QUIT THE GAME
       jp     nz,nocheat2  ; if not cheating
       call   keydebounce
       call   set_up_the_screen
       jp     subsequentStart  ; return to menu via the themetune
nocheat2:
       cp     %01101       ; 2 amd 5                   - BREAK THE MAZE
       jp     nz,nocheat3  ; if not cheating
       xor    a            ; remove the wall that hides the bottom of the maze
       ld     hl,mazebreak1+1
       ld     (hl),a
       ld     hl,mazebreak2+1
       ld     (hl),a
       jr     hanghere     ; skip other cheatmode
nocheat3:


hanghere:   jp          loop

fire:
                  ld          de,(ycoord)
                  ld          hl,aheadofus
                  call        addvector
                  call        getpos_in_maze
                  ld          a,(hl)
                                                   ; END GAME WILL BE TRIGGERED HERE
                  cp          3                       ; is it the EXIT
                  jp          z,EXIT_routine          ; if so EXIT (need to clear stack first)

                  and         %010                       ; is it a special 'white' panel or black panel
                  ret         z                      ; if it's not white, fire does nothing


                  pop         hl                      ; clear the stack




            ld          hl,minigametable  ; pick the game to play
            ld          a,(minigamechoice)      ; the choice
            ld          e,a
            ld          d,0
            add         hl,de             ; hl points to the place in the table
            inc         a
            inc         a                       ; increase table pointer by 2
            and         %111                     ; wrap at 4 back to 0
            ld          (minigamechoice),a      ; store for next minigame
            ld          (getjumpaddress+1),hl
getjumpaddress:
            ld          hl,(0)
            jp          (hl)              ; junps TO HL, not to address pointed to by HL

                  ; jump to minigame

movef:                                                      ; move forward
                  ld          de,(ycoord)
                  ld          hl,aheadofus
                  call  addvector
                  push  de
                  call  getpos_in_maze
                  ld          a,(hl)
                  pop         de
                  cp          0
                  ret         nz                            ; if it's not a space, return
                  ld          (ycoord),de             ; otherwise, update position
                  ret

moveb:                                                      ; move forward
                  ld          de,(ycoord)
                  ld          hl,behindus
                  call  addvector
                  push  de
                  call  getpos_in_maze
                  ld          a,(hl)
                  pop         de
                  cp          0
                  ret         nz                            ; if it's not a space, return
                  ld          (ycoord),de             ; otherwise, update position
                  ret

mpl:
                                                            ;     - updates colours to turn left
                  ld          a,(frontcol)                        ; turn left
                  ld          b,a
                  ld          a,(leftcol)
                  ld          (frontcol),a
                  ld          a,(backcol)
                  ld          (leftcol),a
                  ld          a,(rightcol)
                  ld          (backcol),a
                  ld          a,b
                  ld          (rightcol),a

                  ld          hl,(aheadofus)
                  ld          de,(leftofus)
                  ld          (aheadofus),de
                  ld          de,(behindus)
                  ld          (leftofus),de
                  ld          de,(rightofus)
                  ld          (behindus),de
                  ld          (rightofus),hl
                  jp          turnnoise

mpr:
                                                            ;     - updates colours to turn right
                  ld          a,(frontcol)                        ; turn right
                  ld          b,a
                  ld          a,(rightcol)
                  ld          (frontcol),a
                  ld          a,(backcol)
                  ld          (rightcol),a
                  ld          a,(leftcol)
                  ld          (backcol),a
                  ld          a,b
                  ld          (leftcol),a

                  ld          hl,(aheadofus)
                  ld          de,(rightofus)
                  ld          (aheadofus),de
                  ld          de,(behindus)
                  ld          (rightofus),de
                  ld          de,(leftofus)
                  ld          (behindus),de
                  ld          (leftofus),hl
                  jp          turnnoise

turnnoise:
                  call  colourcompass


sound_setup:                                    ;"qukkkkk" sound, when you turn
                  ld de, 5                                  ;
                  ld b,3
                  ld hl, 938                                ; pitch
sound_loop:
                  dec h
                  push bc
                  push de
                  push hl
                  call 949                                  ; call ROM beeper routine
                  pop hl
                  pop de
                  pop bc
                  djnz sound_loop
                  
                  call keydebounce                          ; stops over rotating

                  ret

colourcompass:          ;                       draw the colour compass
                  ld          a,(frontcol)
                  ld          hl,$5800+30
                  call  colour_hl_ink_and_paper
                  ld          a,(leftcol)
                  ld          hl,$5800+32+29
                  call  colour_hl_ink_and_paper
                  ld          a,(rightcol)
                  ld          hl,$5800+32+31
                  call  colour_hl_ink_and_paper
                  ld          a,(backcol)
                  ld          hl,$5800+64+30
                  call  colour_hl_ink_and_paper

colour_hl_ink_and_paper:                  ; colours (hl) with a (ink and paper same)
                  ld          (hl),a
                  or          a           ; clear carry flag
                  rla
                  rla
                  rla                     ; ink becomes paper
                  or          (hl)  ; ink and paper the same
                  and         %111111     ; no bright/flash
                  ld          (hl),a
                  ret               
                  
clearcolourcompass:
                  xor         a
                  ld          hl,$5800+30
                  ld          (hl),a
                  ld          hl,$5800+32+29
                  ld          (hl),a
                  inc         hl
                  inc         hl
                  ld          (hl),a
                  ld          hl,$5800+64+30
                  ld          (hl),a
                  ret
                  
;-------------------------------------------------------------------------------
;DRAWS THE VIEW FROM CURRENT POSITION                 
;-------------------------------------------------------------------------------

drawview:
                  ld          hl,depthcount
                  ld          (hl),5
                  ld          de,(ycoord)
                  push  de
                  call  colourwallgaps          
                  pop         de
                  ld          (ycoord),de       
                  ret
                  
colourwallgaps:
                  ld          de,(ycoord)
                  ld          hl,leftofus
                  call  addvector               ; de now points at square to the left
                  call  getpos_in_maze          ; turn this into a memory address returned in HL
                  ld          a,(hl)
                  cp          0                             ; check if it is zero
                  push  af
                  ld          a,(depthcount)
                  call  z,draw_left_door_a      ; if so, draw the appropriate tunnel
                  pop         af
                  cp          2
                  ld          a,(depthcount)
                  call        nc,draw_left_panel_a     ; if it is 2, draw a panel

                  ld          de,(ycoord)
                  ld          hl,rightofus            ;
                  call        addvector               ; de now points at square to the right
                  call        getpos_in_maze          ; turn this into a memory address returned in HL
                  ld          a,(hl)
                  cp          0                             ; check if it is not a wall
                  push        af
                  ld          a,(depthcount)
                  call        z,draw_right_door_a ; if so, draw the appropriate tunnel
                  pop         af
                  cp          2
                  ;ld          a,(depthcount)
                  call        nc,draw_right_panel_a    ; if it is 2, draw a panel


                  ld          de,(ycoord)             ; e=y,d=x

                  ld          hl,aheadofus
                  call        addvector               ; de now points at square ahead
                  call        getpos_in_maze          ; turn this into a memory address returned in HL
                  ld          a,(hl)
                  cp          0                             ; check if it is a wall
                  ld          a,(depthcount)
                  push        af                            ; save flag
                  call        nz,draw_deadend_a    ; if it is, draw the appropriate deadend
                  pop         af                            ; restore flags
                  ret         nz                            ; if we did a deadend, we're done

                  ld          hl,depthcount
                  ld          a,(hl)
                  or          a
                  ret         z                             ; drawn as far as we can
                  dec         a
                  ld          (hl),a

                  ld          de,(ycoord)
                  ld          hl,aheadofus            ; move 'viewpoint' forward
                  call        addvector
                  ld          (ycoord),de

                  jr          colourwallgaps



            
;-------------------------------------------------------------------------------
;ADDVECTOR adds 'vector' stored in the address by HL to DE
;------------------------------------------------------------------------------
addvector:                                            ; used in checking whether positions are to be drawn
                  ld          a,(hl)                        ; add HL vector to de
                  add         a,e
                  ld          e,a
                  inc         hl
                  ld          a,(hl)
                  add         a,d
                  ld          d,a                           ; de now has modified position to be checked
                  ret

;----GET POSITION IN MAZE DE in HL out
getpos_in_maze:                                       ; DE returns hl with position in maze (preserves all others)
                  ld          l,d                           ; momentarily save d
                  ld          d,0
                  or          a                             ; clear carry flag
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  rl          e
                  rl          d                             ; x32
                  ld          h,0
                  add         hl,de
                  ex          de,hl
                  ld          hl,maze
                  add         hl,de                   ; hl now contains position in maze
                  ret
;----GET POSITION IN MAZE DE in HL out, end                 
                  

                  
                  ;halt
                  ;ld   a,3
                  ;out  (254),a                                   ; check time taken
                  ;call setuptunnelcolour
                  ;ld   a,0
                  ;out  (254),a
                  ;call       colourbuffertoscreen
                  ;ld   a,6
                  ;out  (254),a     




;----------------------------
;draw deadend A (from lookup table) ()
; called with HL looking at the address in the maze. (HL)=1 > normal wall (HL=2) > special
;----------------------------

draw_deadend_a:
                  dec         (hl)                          ; if it's NOT a 1, then it's 2,3,4
                  jr          nz,drawwhitedeadend
                  inc         (hl)
                  
                  ld          hl,deadend_lookup
                  ld          e,a
                  ld          d,0
                  rl          e
                  rl          d     ;multiply by 2
                  add         hl,de ;hl now points at the position in table
                  
                  ld          a,(hl)
                  ld          d,a
                  ld          e,a
                  inc         hl
                  ld          a,(hl)
                  ld          b,a
                  ld          c,a
                  
                  call  de_coords_toscrathcaddress
                  
                  ld          a,(frontcol)
                  ld          e,a
                  rl          a
                  rl          a
                  rl          a
                  or          e                 ; ink paper same

                  call  colourbox

                  ret

; sets the magic door colour. relies HL pointing at it in the maze
setmagicdoorcol:
                  push  af
                  ld    a,(hl)
                  cp    2                ; is door 2, i.e. minigame
                  jr    nz,notwhitedoor
                  ld    a,0                ; black 0 unplayed
                  jr    choosemagiccolour
notwhitedoor:
                  cp    4                ; is door '4' i.e. spent minigame
                  jr    nz,notblackdoor
                  ld    a,7                ; 7= spent
                  jr    choosemagiccolour
notblackdoor:
                  ; must be 3! (the magic exit)
                  ld    a,(strobedoor)         ; the door coulour will change magically
                  inc   a
                  cp    8
                  jr    nz,strobeset
                  ld    a,1
strobeset:        ld    (strobedoor),a
                  ;ld    a,7              ; lets set this to white too
choosemagiccolour:
                  ld    (magicdoor),a
                  pop   af
                  ret


;-------------------------------------------------------------------------------
; DRAW A WHITE DEAD END
;-------------------------------------------------------------------------------                
drawwhitedeadend:                   ; THIS IS WHEN THERE'S A special DOORWAY
                  inc         (hl)        ; put it back to correct value
                  
                  call        setmagicdoorcol

                  ld          hl,deadend_lookup
                  ld          e,a
                  ld          d,0
                  rl          e
                  rl          d     ;multiply by 2
                  add         hl,de ;hl now points at the position in table
                  
                  ld          a,(hl)
                  ld          d,a
                  ld          e,a
                  inc         hl
                  ld          a,(hl)
                  ld          b,a
                  ld          c,a

                  call  de_coords_toscrathcaddress
                  
                  ld          a,(magicdoor)
                  ld          e,a
                  rl          a
                  rl          a
                  rl          a
                  or          e                 ; ink paper same
                  
                  call  colourbox

                  ret
                  
deadend_lookup:
                  defb  11,2  ; position (same x y coordinate), size of square.
                  defb  10,4
                  defb  9,6
                  defb  7,10
                  defb  5,14
                  defb  1,22

draw_right_panel_a:
                  call        setmagicdoorcol

                  ld          hl,rhdoortable          ; set lookup table
                  jr          drawpanel               ; jmp into lh drawdoor
draw_left_panel_a:
                  call        setmagicdoorcol
;----------------------------------
;DRAWS  PANEL  (A) from lookup table (0-5)
;----------------------------------
draw_panel_a:                                   ; draws Door a to scratch_atrr (A=0-5,6-11)
                  ld          hl,lhdoortable    ; table
drawpanel:
                  ld          a,(depthcount)
                  or          a                       ; clear flags

                  ld          e,a
                  ld          d,0
                  rl          e
                  rl          d
                  rl          e
                  rl          d                       ; multiply by 4
                  add         hl,de             ; hl points to data in table

                  ld          e,(hl)
                  inc         hl
                  ld          d,(hl)                  ; de contains x,y co-ordniates

                  inc         hl
                  ld          b,(hl)
                  inc         hl
                  ld          c,(hl)

                  push        bc

                  call        de_coords_toscrathcaddress          ; DE --> HL scratchaddr

                  ld          a,(magicdoor)
                  ld          c,5*8
                  add         a,c

                  ld          c,b                     ; so it is a b by b box

                  call  colourbox

                  pop         bc
                  push        bc

                  ld          a,(magicdoor)
                  call        colourbox

                  pop         bc

                  ld          a,(magicdoor)
                  ld          c,1*8
                  add         a,c

                  ld          c,b                     ; so it is a b by b box

                  call  colourbox               
                  
                  ret



draw_right_door_a:
                  ld          hl,rhdoortable          ; set lookup table
                  jr          drawdoor                ; jmp into lh drawdoor
draw_left_door_a:
;----------------------------------
;DRAWS  DOOR  (A) from lookup table (0-5)
;----------------------------------
draw_door_a:                                    ; draws Door a to scratch_atrr (A=0-5,6-11)
                  ld          hl,lhdoortable    ; table
drawdoor:               
                  or          a                       ; clear flags

                  ld          e,a
                  ld          d,0
                  rl          e                       
                  rl          d
                  rl          e
                  rl          d                       ; multiply by 4
                  add         hl,de             ; hl points to data in table
                        
                  ld          e,(hl)
                  inc         hl          
                  ld          d,(hl)                  ; de contains x,y co-ordniates
                  
                  inc         hl
                  ld      b,(hl)
                  inc         hl
                  ld          c,(hl)

                  push  bc

                  call  de_coords_toscrathcaddress          ; DE --> HL scratchaddr

                  ld          a,(topcol)
                  
                  ld          c,a                     ; temporarily use C to make...
                  rl          a                       ;
                  rl          a                       ;
                  rl          a                       ;
                  or          c                       ; paper and ink same
                  
                  ld          c,b                     ; so it is a b by b box
                  
                  call  colourbox

                  pop         bc
                  push  bc
                  
                  ld          a,(frontcol)
                  call  colourbox

                  pop         bc

                  ld          a,(botcol)

                  ld          c,a                     ; temporarily use C to make...
                  rl          a                       ;
                  rl          a                       ;
                  rl          a                       ;
                  or          c                       ; paper and ink same
                  
                  ld          c,b                     ; so it is a b by b box

                  call  colourbox
                  
                  ret
                  




;------------------------------------------------------------------------------
;A 'colour a box' at HL of size B,C routine - leaves HL pointing at next space      
;-------------------------------------------------------------------------------
colourbox:

                  ld          d,b                     ; store b and c away
columns_loop:
                  push  hl
rows_loop:              
                  ld          (hl),a
                  inc         hl
                  djnz  rows_loop
                  pop         hl
                  ld          b,d
                  ld          de,32
                  add         hl,de
                  ld          d,b
                  dec         c
                  jr          nz,columns_loop               

                  ret

                  
;--------------------------------               
de_coords_toscrathcaddress:         ; turns DE co-ordinates into hl [A/BC untouched]                  
                  ld          hl,SCRATCHATTR
                  push  de                      ;ld         a,d
                  ld          d,0
                  add         hl,de
                  pop         de
                  ld          e,d
                  ld          d,0
                  rl          e           ; multiply by 32
                  rl          d
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  add         hl,de ; hl now has top of door position in SCRATCHATTR
                  ret
;                 end of de_coords_toscrathcaddress
;-----------------------------


                  



; left hand door sizes and positions (x,y position then size width, height)
lhdoortable:

                  defb  10,10,1,2         ; at 9,9 then 1x1 top/bottom & 1x2 middle
                  defb  9,9,1,4
                  defb  7,7,2,6
                  defb  4,4,3,10
                  defb  1,1,4,14                
                  defb  0,0,1,22



rhdoortable:
                  defb  13,10,1,2         ; at 9,9 then 1x1 top/bottom & 1x2 middle
                  defb  14,9,1,4
                  defb  15,7,2,6
                  defb  17,4,3,10         
                  defb  19,1,4,14                                       
                  defb  23,0,1,22



;-----------------------------
; set up the GAMEFLAGS colours to indicate there are things in each direction
;---------------------------------------
setupindicators:              
                  ld          hl,gameflags      ; clear the flags
                  xor         a
                  ld          (hl),a
                  inc         hl
                  ld          (hl),a
                  inc         hl
                  ld          (hl),a
                  inc         hl
                  ld          (hl),a

                  ;
                  
                  ld          de,(ycoord)             ; check from top of maze
                  ld          c,0
loopmazedoors1:
                  push  de
                  ld          d,c
                  call  getpos_in_maze          ; de becomes HL address in maze
                  ld          a,(hl)
                  ld          hl,gameflags
                  or          (hl)
                  ld          (hl),a
                  pop         de
                  inc         c
                  ld          a,d
                  cp          c
                  jr          nz,loopmazedoors1
                  ld          a,(hl)
                  and     %10
                  ld          c,a
                  rra
                  or          c                             ; magenta is yes, black if not
                  ld          (hl),a

                  ld          de,(ycoord)             ; check from left hand side of maze
                  ld          c,0
loopmazedoors2:
                  push  de
                  ld          e,c
                  call  getpos_in_maze          ; de becomes HL address in maze
                  ld          a,(hl)
                  ld          hl,gameflags+1
                  or          (hl)
                  ld          (hl),a
                  pop         de
                  inc         c
                  ld          a,e
                  cp          c
                  jr          nz,loopmazedoors2
                  ld          a,(hl)
                  and     %10                         ; red if yes, black if not
                  ld          (hl),a


                  ld          de,(ycoord)             ; check from right hand side of maze
                  ld          c,31
loopmazedoors3:
                  push  de
                  ld          e,c
                  call  getpos_in_maze          ; de becomes HL address in maze
                  ld          a,(hl)
                  ld          hl,gameflags+2
                  or          (hl)
                  ld          (hl),a
                  pop         de
                  dec         c
                  ld          a,e
                  cp          c
                  jr          nz,loopmazedoors3
                  ld          a,(hl)
                  and     %10                         ; green if yes, black if not
                  rla
                  ld          (hl),a

                  ld          de,(ycoord)             ; check from bottom of maze
                  ld          c,31
loopmazedoors4:
                  push  de
                  ld          d,c
                  call  getpos_in_maze          ; de becomes HL address in maze
                  ld          a,(hl)
                  ld          hl,gameflags+3
                  or          (hl)
                  ld          (hl),a
                  pop         de
                  dec         c
                  ld          a,d
                  cp          c
                  jr          nz,loopmazedoors4
                  ld          a,(hl)
                  and     %10                         
                  ld          c,a
                  rla
                  or          c                             ; yellow if yes, black if not
                  ld          (hl),a
                  ret                                       ; end of SETUP GAMEFLAGS


;---------------------
;pretty routine to use border to indicate if there are things in different directions
;---------------------
border_stuff:
                                                      ; border handling
                  ld          a,0   
                  out         (254),a                 ; black border

                  ld          bc,$0004
self1       djnz  self1
                  dec         c
                  jr          nz,self1
                  
                  ld          hl,gameflags
                  ld          e,5
brderflglp: dec         e
                  jr          z,nomoreborder
                  xor         a
                  out   (254),a
                  ld          b,0
self3       djnz  self3             ; thin black border stripe
                  ld          a,(hl)
                  out         (254),a
                  ld          bc,$0002
self2       djnz  self2             ; wide colour border stripe
                  dec         c
                  jr          nz,self2
                  
                  inc         hl
                  jr          brderflglp
nomoreborder:
                  
                  ld          a,0                     ; back to black border
                  out   (254),a                 ; end of border prettiness
                  ret

;--------------------
;setuptunnelcolour (no doors) in the scratch ATTR
;-------------------

setuptunnelcolour:
setupcolour:
                  call  setupink

                  ld          de,8
                  ld          hl,SCRATCHATTR


                  ld          a,(topcol)
                  rla                                 ; get it in the paper position
                  rla
                  rla
                  ld          (paploop1+1),a    ; set up self modifying code
                  call  setuppap
                  ld          a,(botcol)
                  rla                                 ; get it in the paper position
                  rla
                  rla
                  ld          (paploop1+1),a    ; set up self modifying code
                  call  setuppap
                  ret

setuppap:
                  ld          c,12
paploop2:
                  ld          b,24
paploop1:
                  ld          a,7
                  or          (hl)
                  ld          (hl),a
                  inc         hl
                  djnz  paploop1
                  add         hl,de
                  dec         c
                  jr          nz,paploop2

                  ret   

setupink:
                  ld          de,8

                  ld          c,24
                  ld          hl,SCRATCHATTR
rowofboth:
                  ld          a,(leftcol)             
                  call  rowofink
                  ld          a,(rightcol)
                  call  rowofink
                  add         hl,de
                  dec         c
                  jr          nz,rowofboth
                  ret
rowofink:
                  ld          b,12
colsetuploop1:
                  ld          (hl),a
                  inc         hl
                  djnz  colsetuploop1
                  ret               


;--------------------
;end of setuptunnelcolour (no doors) in the scratch ATTR
;-------------------


;-----------------------
;Colour Buffer To Screen
;-----------------------
colourbuffertoscreen:
                  ld          hl,SCRATCHATTR
                  ld          de,$5800                            ; attributes
                  ld          c,24
loopcolbuf1:
                  ld          b,24
loopcolbuf2:
                  ld          a,(hl)
                  ld          (de),a
                  inc         hl
                  inc         de
                  djnz  loopcolbuf2

                  push  bc
                  ld          bc,8
                  add         hl,bc
                  ex          de,hl
                  add         hl,bc
                  ex          de,hl
                  pop         bc
                  dec         c
                  ret         z
                  jr          loopcolbuf1
                  
;-----------------------
;End of Colour Buffer To Screen
;-----------------------


;-------
;Set up variables, screen and UDGs
;-----
set_up_the_screen:
                  ld      a,2              ; Printing to the Upper screen
                  call    5633             ; Open channel
                  ld      a,0              ; 0 is the code for black
                  call    8859             ; set border colour.
                  ld      a,7                ; white ink, black paper
                  ld      (23693),a        ; set our screen colours.
                  call    3503             ; clear the screen.

                  ld          hl,(23675)                          ; get the address of the UDGs
                  ld          de,UDGS                                   ; get my UDGs
                  ex          de,hl
                  ld          bc,40
                  ldir                                            ; set up those UDGs

                  ret
;-----------
;end of setup
;-----------


;-----------------------------------
;DRAW TUNNEL - graphics
;all registers are used
;------------------------------------
drawtunnel:
                  xor         a      ; black on black attribute
                  ld          (23624),a    ; bottom of screen printing
                  ld          (23695),a    ; screen pritning sys variables


                  ld          a,22
                  rst         16
                  xor         a
                  rst         16
                  xor         a
                  rst         16

                  ld          hl,$9091                            ; these are the slopes

                  ld          d,0
lineloop1:

                  call  slopeandgap
                  ld          a,13
                  rst         16
                  inc         d
                  ld          a,12                                ; test if we're at the end
                  cp          d
                  jr          nz,lineloop1

                  ld          d,11


                  ld          hl,$9392                            ; these are the slopes
lineloop2:

                  call  slopeandgap
                  ld          a,13
                  rst         16
                  dec         d
                  ld          a,1                                 ; test if we're at the end
                  cp          d
                  jr          nz,lineloop2

                  push  de

                  ld      a,1              ; Printing to the Upper screen
                  call    5633             ; Open channel

                  ld          a,22
                  rst         16
                  xor         a
                  rst         16
                  xor         a
                  rst         16

                  pop         de
                  ld          hl,$9392
                  call  slopeandgap
                  ld          a,13
                  rst         16
                  dec         d
                  call  slopeandgap


                  ret

slopeandgap:
                  ld          b,d
                  ld          a,$94                               ; Prints a row of squares
                  call    lineofas
                  ld          a,l                                       ; and a slope
                  rst         16

                  ld          e,d
                  ld          a,22
                  sub         e
                  sub         e
                  ld          b,a
                  ld          a,32                                ; prints a row of SPACEs
                  call  lineofas

                  ld          a,h                                       ; prints a slope
                  rst         16
                  ld          b,d
                  ld          a,$94                               ; prints row of squares
                  call  lineofas

                  ret


lineofas:                                                         ; print B versions of the A
                                                                        ; character. B can be 0.
                  ld          c,a                                       ; C is corrupted
                  xor         a
                  or          b
                  ret         z
                  ld          a,c
                  rst         16
                  ld          a,c
                  dec         b
                  jr          lineofas



;-----------------
;End of DRAW TUNNEL
;------------------


;writemessage:                                                    ; write a message of length DE
                                                                        ; HL points to message
 ;           ld         a,(hl)
 ;           rst        16
 ;           dec        de
 ;           ld         a,d
 ;           or         e
 ;           ret        z
 ;           inc  hl
 ;           jr         writemessage



;                 ld          hl,testmessage
;                 ld          de,testmessage_end-testmessage
;           call  writemessage
;                 ld          a,13
;                 rst         16



;testmessage:
;                 defb  22,0,0,$90,$91,$92,$93,$94
;testmessage_end:


;----------
; Copied into the UDB position, as defined by the system variable
;---------
UDGS:
                  defb   1,3,7,15,31,63,127,255,128,192,224,240,248,252,254,255
                  defb   255,254,252,248,240,224,192,128,255,127,63,31,15,7,3,1     
                  defb   255,255,255,255,255,255,255,255


;                 23675/6 is the udg chars system variable



;                  defs  768,56

;---------------------------
;PLAY A MINIGAME - FLAPPY
;---------------------------

sizeofgap:  defb  10   ; will reduce
flapscore:  defw  0
flappos:    defb  10*4 ; movement will be bit shifted
flapvec:    defb  -2   ; vector to be added each time
flapspeed:  defb  0    ;
birdseed:   defb  0
oldbirdpos: defw  00   ; used to erase bird
oldwingpos: defw  00   ; used to erase wing
birdcount:	defb 0
flapwingflag: defb 255 ; wing up/down flag
oldwingcolour: defb 0  ; stores the old wing colour (in case wing is in border)
scrollflag:    defb 0  ; does it scroll
numofwalls:    defb 0

minigame4:
			call	clearcolourcompass
			call	fade_to_black

			call    rand_8
			ld      (birdseed),a


                        ld    hl,minigame4message
                        call  bigready                        ; print the ready message
                        ld    hl,jingle4
                        call  playjingle        ; play jingle 2
			; called when at a white panel, and fire is pressed

                        call  clear_mini_screen
clear_scratchattrminiscreen:
                  ld          hl,SCRATCHATTR+32+1
                  ld          de,10
                  ld          c,22
scnextline:       ld          b,22
scnextchr:        ld          (hl),0                  ; black
                  inc         hl
                  djnz        scnextchr
                  add         hl,de
                  dec         c
                  jr          nz,scnextline

			ld      a,10
			ld	(sizeofgap),a			; set up size of gap
			ld	hl,0				; set up score 0
			ld      (flapscore),hl
			call    display_HL                      ; display 0000
                        ld      a,7*8				; set up position on screen of bird x4
			ld	(flappos),a
			ld	a,-7				; set up gravity vector
			ld	(flapvec),a
			xor	a
			ld	(flapspeed),a
                        ld	(birdcount),a			; set up the counter of how far along we are
                        ld      (flapwingflag),a
                        ld      (numofwalls),a

                        ld      (oldwingcolour),a                ; SETS THE COLOUR AND OLD WING POS TO ROM
                        ld      hl,0
                        ld      (oldwingpos),hl

                        ld      hl,freqofgaps+1
                        ld      (hl),48                           ; sets the frequency of walls

;draw a wall - routine
birddrawwall:

			ld	de,32
			ld	hl,SCRATCHATTR+32+22
			ld	b,22
birdwallloop
			ld	(hl),1+8+64 	;bright blue
			add	hl,de
			djnz	birdwallloop

			call	randbird	; need to set up limits based upon hole size
								;  need to draw the hole!
			ld	hl,0
			ld      de,32
findgaploop:
                        dec     a
                        jr      z,foundgappos
                        add     hl,de
                        jr      findgaploop
foundgappos:
                        ex      de,hl
			ld	hl,SCRATCHATTR+32+22
                        add     hl,de
                        ld      de,32
   			ld      a,(sizeofgap)
                        ld      b,a
makegaploop:
                        ld	(hl),0           ; black 7+7*8
                        add     hl,de
                        djnz    makegaploop


flappybirdloop:                                        ; jumps back to here if not drawing wall

			halt
easymod1:               nop
                        halt


;removebird
			ld		hl,(oldbirdpos)
                        ld		(hl),0
                        dec		hl
                        ld		(hl),0
                        ld              hl,(oldwingpos)
                        ld              a,(oldwingcolour)
                        ld              (hl),a


scrollwall:
                        ld              a,(scrollflag)
                        inc             a
                        cp              3
                        jr              z,scrollthistime
                        ld              (scrollflag),a
                        jr              donescroll

scrollthistime:
                        ld              a,0
                        ld              (scrollflag),a   ;reset flag

			ld		de,SCRATCHATTR+32+1
			ld		hl,SCRATCHATTR+32+2
			ld		c,22
scrollwalllp2:
			ld		b,21
scrollwalllp1:
			ld		a,(hl)
			ld		(de),a
			inc 	        hl
			inc 	        de
			djnz	        scrollwalllp1
			ld		a,0
			ld		(de),a
			ld		de,11
			add		hl,de
			ld		d,h
			ld		e,l
			dec		de
			dec		c
			jr		nz,scrollwalllp2
donescroll:

          ;  call            colourbuffertoscreen


;drawbird
            ld		a,(flappos)    ; the height the bird is at (0 at the top)
            and		%11111000
            ld		e,a
            ld		d,0
            or		a		; clear carry
            rl		e
            rl		d
            rl 		e
            rl		d		; multiply by 8

            ld		hl,SCRATCHATTR+32+4
            add		hl,de		; hl now points at back of bird
            call        checkbirdhit    ; check if the bird has hit a wall
            ld		(hl),6+6*8+64
            inc		hl
            call        checkbirdhit    ; check if the bird has hit a wall
            ld		(hl),6+6*8+64	; front of bird

	    ld		(oldbirdpos),hl  ; store old position of bird for deleting
            ld          a,(flapwingflag) ; is wing up or down
            or          a
            jr          z,wingisup       ; if it is zero then wing is in up position
wingisdown;
            ld          de,33             ; wing is one row higher, and one back
            sbc         hl,de
            jr          wingpositionfound
wingisup:
            ld          de,31
            add         hl,de
wingpositionfound:
            call        checkbirdhit    ; check if the bird has hit a wall
            ld          (oldwingpos),hl    ;store old wingposition
            ld          a,(hl)
            ld          (oldwingcolour),a
            ld          (hl),6+6*8               ; dark yellow
; bird is now drawn
            halt
            call            colourbuffertoscreen

; check for scoring
            ld          a,(scrollflag)
            or          a               ; only score once per scroll
            jr          nz,notscoringnow

            ld          hl,SCRATCHATTR+32+3   ; is the blcok behind the bird non black
            ld          a,(hl)          ; either at the tip
            or          a
            jr          nz,scoringnow

            ld          hl,SCRATCHATTR+32*22+3 ; or the bottom. cos this will mean we have just passed a wall
            ld          a,(hl)
            or          a
            jr          z,notscoringnow
scoringnow:
            ld           b,50
flapbeeploop:
            ld           a,255
flapnextcycle:
            dec         a
            and         248
            out         (254),a
            or          a
            jr          nz,flapnextcycle
            djnz        flapbeeploop

            ld          hl,numofwalls      ; increase the scoring by 2 each time
            inc         (hl)
            jr          nc,passedlessthan255
            ld          (hl),255
passedlessthan255:
            ld          a,(hl)
            and         %1   ; so 7 will be first then 15
            jr          nz,dontshrinkgap
            ld          a,(sizeofgap)
            dec         a
            cp          3
            jr          z,moreoftewall  ; 4 is the smallest it can be
            ld          (sizeofgap),a   ; shrinkthegap
            jr          dontshrinkgap
moreoftewall:                           ; once the gap is only 4, lets make them more frequent
            ld          hl,freqofgaps+1
            ld          a,(hl)
            dec         a               ; starts at 48
            dec         a
            dec         a
            cp          24                ; a hard limit
            jr          z,dontshrinkgap
            ld          (hl),a

dontshrinkgap:
            ld          hl,(flapscore)
            ld          a,(numofwalls)
            ld          e,a
            ld          d,0
            or          a  ; clear carry
            rl          e
            rl          d
            rl          e
            rl          d
            rl          e
            rl          d
            rl          e
            rl          d
            add         hl,de
            ld          (flapscore),hl
            call        display_HL
notscoringnow:


; deal with gravity


	    ld		hl,flappos
            ld		a,(flapvec)
            ld          c,a              ; store this for direction
            bit         7,c              ; is it a 'negative'?
            jr          z,checkthefloor  ; if if is positive just check the floor
; travelling upwards
            add		a,(hl)           ; add on the vector to the position to give new position
            jr          nc,hitroof
            jr          nothitroof
hitroof:
            ld          a,0            ; bounces off roof a bit
            ld          (flapvec),a
            ld          a,8              ; and is at the roof position

nothitroof:
            jr   floorseceilingok


checkthefloor:
            add		a,(hl)              ; add on the vector to the position to give new position
; deal with the floor (bounce)
	    cp		22*8                ; dirty "bounce on the floor routine"
            jr		c,flapgravok	    ; is it off the bottom of screen
            ld		a,(flapvec)	    ; get the vector
            or          a                   ; clear cary flag
            rra                             ; divide it by 2
            ld          c,a                 ; store 1/2 in c
            or          a                   ; clear carry again
            rr          c                   ; half of half = 1/4
            add         a,c                 ; a now = 3/4 of what it was

            neg				    ; negate it
;            jp          p,positivector
halvedvecot
            ld		(flapvec),a	    ; store it
            ld           a,21*8   	    ; set the position to 'the floor'
flapgravok:								;

floorseceilingok:
            ld		(hl),a
            ld		a,(flapvec)
	    inc		a
            cp		30
            jr		z,maxvec
            ld		(flapvec),a
maxvec:								;maximum gravity


            ld   bc,32766 		   ; B, N, M, Symbol Shift, Space
	    in   a,(c)
            cpl					    ;
	    and   %101				; consider M and Space
	    jr	nz,flapflap			; if it's being pressed
	    jr 	noflapping

flapflap:                                         ; player is flapping
            ld   hl,flapvec
            ld   a,(hl)
            dec  a
            dec  a
            dec  a
            ld   (hl),a
            ld   hl,flapwingflag                       ; invert the wing position flag
            ld   a,(hl)
            cpl
            ld   (hl),a
noflapping:


	    ld		hl,birdcount    ; how often should we draw walls
            ld		a,(hl)
            inc		a
            ld		(hl),a
freqofgaps: cp		48				; draw a wall every 48 - modified later
            jp 		nz,flappybirdloop
	    ld		(hl),0
            jp		birddrawwall


checkbirdhit:    ; check if the bird has hit a moving wall
            ld          a,(hl)
            cp          1+8*1+64    ; is it a wall
            ret         nz          ; if not, we;re good
; bird has hit wall
            pop         bc          ; clear stack
            push        hl          ; store problem where we've hit

            ld		a,(flappos)    ; the height the bird is at (0 at the top)
            and		%11111000
            ld		e,a
            ld		d,0
            or		a		; clear carry
            rl		e
            rl		d
            rl 		e
            rl		d		; multiply by 8

            ld		hl,SCRATCHATTR+32+4
            add		hl,de		; hl now points at back of bird
            ld		(hl),6+6*8+64
            inc		hl
            ld		(hl),6+6*8+64	; front of bird
            ld          a,(flapwingflag) ; is wing up or down
            or          a
            jr          z,wingisup1       ; if it is zero then wing is in up position
wingisdown1;
            ld          de,33             ; wing is one row higher, and one back
            sbc         hl,de
            jr          wingpositionfound1
wingisup1:
            ld          de,31
            add         hl,de
wingpositionfound1:
            ld          (oldwingpos),hl    ;store old wingposition
            ld          a,(hl)
            ld          (oldwingcolour),a
            ld          (hl),6+6*8               ; dark yellow

            pop         hl
            ld          (hl),2+8*2+64


;FLAPPY BIRD EXIT
; make a horrible noise
            call        colourbuffertoscreen

            ld          a,250
            ld          (noise+1),a
            ld          a,90
            ld          (noise0-1),a      ; set up crashfx to be big
            call  crashsfx


            ld          hl,(oldwingpos)          ; restore  this
            ld          a,(oldwingcolour)
            ld          (hl),a




;                 ld          hl,(flapscore)
;                 ld          de,(score)
;                 add         hl,de
;                 ld          (score),hl
                  ld          bc,(flapscore)
                  call        scoreswap



                   call        colourbuffertoscreen
                   call        fade_to_wall

			ld	hl,(score)
			call	display_HL
			ld	b,100
pause22:		ld	c,100
pause21:	        dec	c
			jr	nz,pause21
			djnz	pause22
			call	colourcompass

                        call    increaseminigames ; increase the number of games played
                       	jp	loop		; return to maze game
randbird:						; using rom - random bird heights of hole
                        ld      a,(sizeofgap)
                        ld      b,a
                        ld      a,23
                        sub     b                       ; max it can be is (gap) less than 22
                        ld      (randbirdsmc+1),a

                        push	hl
randbirdreject:
			ld		hl,birdseed
			ld		a,(hl)
			inc     a
			ld		(birdseed),a
			ld      l,a
			ld      h,0
			ld      a,(hl)
			and     %11111 	;0 to 32
randbirdsmc:
			cp      22			; maximum it can be
			jr      nc,randbirdreject
			pop		hl
                        inc     a

                 ;       push    hl            ;   debug the 'gap' position.
                 ;       push    af            ;
                 ;       ld  a,22              ;
                 ;       rst 16                ;
                 ;       ld a,1                ;
                 ;       rst 16                ;
                 ;       ld a,24               ;
                 ;       rst 16                ;
                 ;       pop     af            ;
                 ;       push af               ;
                 ;       ld      c,a           ;
                 ;       ld      b,0           ;
                 ;       call 6683 ; print BC  ;
                 ;       ld a,32               ;
                 ;       rst 16                ;
                 ;       pop af                ;
                 ;       pop     hl             ;

            ret


;----------
;END OF FLAPPY
;-----------
;---------------------------
;PLAY A MINIGAME - WORM
;---------------------------

minigame1:
                  call  clearcolourcompass
                  call  fade_to_black

                  call  rand_8                   ;
                  ld    (mempos),a               ; set up random seed


                  ld    hl,minigame1message
                  call  bigready                        ; print the ready message
                  ld    hl,jingle1
                  call  playjingle                      ; play the worm tune

                  ; called when at a white panel, and fire is pressed
                  ld          hl,0
                  ld          (counter),hl
                  ld          a,10
                  ld          (player_pos),a
                  ld          hl,player_pos
                  ld          de,player_oldpos
                  ld          bc,5
                  ldir                          ; populate old positions with startpos
                  ld          a,8
                  ld          (gap),a                 ; reset things

                  call  clear_mini_screen

gameloop:
                  ld          hl,$5800+64+32+32+32                ; DRAW WORM
                  ld          de,(player_pos)
                  ld          d,0
                  add         hl,de
                  ld          a,(hl)                              ; check screen for crash
                  ld          (hl),3*8+3                    ; draw head of worm
                  or          a                                   ; was the road clear
                  jp          nz,worm_crash                 ; worm crash


       ld bc,57342         ; keyboard row POIUY
       in a,(c)            ; see what keys are pressed.
       rra                 ; outermost bit = key P.
       push af             ; remember the value.
       call nc,mvplr       ; it's being pressed, move right.
       pop af              ; restore accumulator.
       rra                 ; next bit along (value 2) = key O.
       call nc,mvpll       ; being pressed, so move left.
       jr keysdone

mvpll:
            ld    hl,player_pos
            ld    a,(hl)
            dec   a
            ld    (hl),a
            ret
mvplr:
            ld    hl,player_pos
            ld    a,(hl)
            inc   a
            ld    (hl),a
            ret
keysdone:

                  ld          hl,(counter)
                  inc         hl
                  ld          (counter),hl
                  ld          a,l
                  or          a                 ; has counter gone to 256
                  jr          nz,gapsame
                  ld          a,(gap)           ; if yes, then reduce gap
                  dec         a
                  cp          3
                  jr          z,gapsame
                  ld          (gap),a
gapsame
                  ld          a,(mempos)
                  inc         a
                  ld          (mempos),a
                  ld          l,a
                  ld          h,1

                  ld          a,(hl)

                  and         %11
                  jr          z,nochange
                  cp          %01
                  jr          z,nochange

                  and         1
                  jr          z,moveleft
moveright:
                  ld          a,(offset)
                  inc         a
                  ld          bc,(gap)
                  ld          b,a               ; store the position
                  add         a,c               ; c is the gap
                  cp          18                                                             ; ARGGGGHHHH
                  ld          a,b               ; restore the position
                  jr          z,nochange
                  jr          updateoffset
moveleft:
                  ld          a,(offset)
                  dec         a

                  jr          z,nochange
updateoffset:
                  ld          (offset),a
nochange:   ld          a,(offset)

print_racetrack:                    ; print the racetrack

                  ld          a,(offset)
                  ld          hl,5800h+32*22+1
leftedge:   ld          (hl),4*8+4
                  inc         hl
                  dec         a
                  jr          nz,leftedge

                  ld          a,2*8+2
                  ld          (hl),a
                  ld          a,(counter)
                  and         %100
                  jr          z,alternatecol
                  ld          a,7*8+7
                  ld          (hl),a
alternatecol:
                  ld          a,(hl)
                  inc         hl
                  ld          (hl),a
                  inc         hl
                  push  af                ; save this col

                  ld          a,(gap)
gaploop:    ld          (hl),0
                  inc         hl
                  dec         a
                  jr          nz,gaploop

                  pop         af                ; restore col

                  ld          (hl),a
                  inc         hl
                  ld          (hl),a
                  inc         hl

                  ld          a,l
                  and   31
                  ld          c,a
                  ld          a,23
                  sub         c
rightedge:  ld          (hl),4*8+4
                  inc         hl
                  dec         a
                  jr          nz,rightedge


                  halt
                                                            ; shifts the previous snake body parts
                  ld          hl,player_pos+4         ; in the table, and clears the last part
                  ld          de,player_pos+5         ;
                  ld          bc,5                    ;
                  lddr                                ; shift positions down in the old position table
                  ld          a,(player_oldpos+4)     ;
                  ld          l,a                           ;
                  ld          h,0                           ;
                  ld          de,$5800+64             ;
                  add         hl,de                   ;
                  xor         a                             ;
                  ld          (hl),a                        ; and clear the last one from the screen




                  call  scroll_attr_down
                  halt
easymod2:         nop


;                 ld          hl,5800h+32*22+1  ; clear a line
;                 ld          a,22
;clearln:   ld          (hl),0
;                 inc         hl
;                 dec         a
;                 jr          nz,clearln

                  ;ld         a,(gap)
                  ;ld         hl,$5800+32+26
                  ;call display_digit

                  ld          hl,(counter)
                  call        display_HL        ; counter and score are different (but the same)

                  jp          gameloop


;--------------------------------
;WORM CRASH ROUTINE - HL points to head of worm
;---------------------------------
worm_crash:
                  ld          a,6*8+6+64+128
                  ld          (hl),a

            ld          a,250
            ld          (noise+1),a
            ld          a,90
            ld          (noise0-1),a      ; set up crashfx to be big
            call  crashsfx

;                 ld          hl,(counter)
;                 ld          de,(score)
;                 add         hl,de
;                 ld          (score),hl
                  ld          bc,(counter)
                  call        scoreswap

                  call        fade_to_wall

                  ld          hl,(score)

                  call        display_HL
                  ld          b,100
pause2:           ld          c,100
pause1:           dec         c
                  jr          nz,pause1
                  djnz        pause2

                  call  colourcompass

                  call   increaseminigames ; increase number of minigames played, and draw more if needed
                  jp     loop        ; return to maze



mempos:     defb  0                 ; used as randomseed
offset:     defb  6                 ;
gap:        defb  8
counter:    defw  0

player_pos: defb  10
player_oldpos:
                  defb  10,10,10,10,10,10

;----------
;END OF WORM
;-----------

;-------------------------------------
; score goes up as the BC goes down
; called with BC holding the score to be added to (SCORE)
; if practice flag is 1 (i.e. it is a practice game, this does nothing)
;-------------------------------------
noiseflag:                            defb 0
scoreswap:
                  ld    a,(practiceflag) ; was this a practice game
                  cp    1
                  jr    nz,scorerealgame
                  pop   bc
                  ret                   ; exit back to menu
scorerealgame:
                  push  bc
                  call  clear_mini_screen
                  ld    hl,scoreswapmessage
                  call  bigready
                  pop   bc
                  di
                  call  scoreswaploop
                  xor   a                  ; border 0
                  out   (254),a
                  ei

;
;                 here check for EXIT (score>9999)
                  ld   hl,(score)
easymod5:         ld   de,9999                                    ;     --------------------- this number needs to be 9999
                  or   a ; clear carry
                  sbc  hl,de
                  jr   c,leavescoreswap                         ; hl is less than 9999

;remove all panels

                  call make_all_panels_spent                     ; remove all panels from the map
                  ld   a,1
                  ld   (exitingmazeflag),a                       ; set exiting maze flag
make_an_exit:
                  call randomdoorpos24
                  ld   (hl),3                                    ; set it as a flashing door

                  call fade_to_black
                  ld   de,0202h
                  ld   (bigtextcoords),de
                  ld   hl,EXIT_message0
                  call bigtext

                  ld   hl,0
                  call display_HL

                 ld    hl,findmessage
                 call  printdiagword
                 call  prinrhtenumber_word


                  ld   hl,exitjingle
                  call playjingle
                  jr   leavescoreswap

EXIT_message0:    defb "MAGICPANELEXITSMAZE;",255


leavescoreswap:
                  di   ; stop timer
                  call  waitforkeypress
                  ei   ; start timer
                  ret


scoreswaploop:
                  ld    a,c

nzloop            ld    l,a
                  and   248
                  out   (254),a
                  ld    a,l
                  dec   a
                  jr    nz,nzloop
                  push  bc
                  ld    h,b
                  ld    l,c
                  call  display_HL
                  ld    hl,(score)
                  call  display_HL_CENTRE
                  pop   bc
                  ld    a,b
                  or    c          ; is BC 0?
                  ret   z          ; if so - return
                  ld    hl,(score) ; if not inc score
                  inc   hl
                  ld    (score),hl
                  dec   bc
                  jr    scoreswaploop ; loop

;------------------------------------------------------------------------
;clear map of panels routine
;-------------------------------------------------------------------------
clear_all_panels:
                 ld   hl,maze
                 ld   bc,32*24                                           ; the maze, just the bit we're using
panels_clear_loop:
                 ld   a,(hl)
                 or   a
                 jr   z,not_wall_element
                 ld   (hl),1                                             ; set it to a wall
not_wall_element:
                 inc  hl
                 dec  bc
                 ld   a,b
                 or   c
                 jr   nz,panels_clear_loop
                 ret

;-------------------------------------------------------------------------
;make all panels spent routine - called after scoring 9999
;------------------------------------------------------------------------
make_all_panels_spent:
                 ld   hl,maze
                 ld   bc,32*24                                           ; the maze, just the bit we're using
panels_spent_loop:
                 ld   a,(hl)
                 or   a
                 jr   z,not_a_wall_element
                 cp   1
                 jr   z,not_a_wall_element
                 ld   (hl),4                                             ; set it to a spent
not_a_wall_element:
                 inc  hl
                 dec  bc
                 ld   a,b
                 or   c
                 jr   nz,panels_spent_loop
                 ret


;----------------
; clear mini screen routine
;----------------

clear_mini_screen:
                  ld          hl,5800h+32+1
                  ld          de,10
                  ld          c,22
nextline:   ld          b,22
nextchr:    ld          (hl),0                  ; black
                  inc         hl
                  djnz  nextchr
                  add         hl,de
                  dec         c
                  jr          nz,nextline
                  ret

;-----------------------------
;PLAY A MINIGAME - City Bomber
;-----------------------------

minigame2:

                  call  clearcolourcompass
                  call  fade_to_black

                  ld    hl,minigame2message
                  call  bigready                        ; print the ready message
                  ld    hl,jingle2
                  call  playjingle        ; play jingle 2


                  ld          hl,0
                  ld          (bombscore),hl
                  ld          hl,21
                  ld          (planepos),hl

                  call  clear_mini_screen

;----------------
;draw a cityscape
;----------------
            ld          de,$5800+32*22+1  ; location of bottom left
            ld          b,22                    ; this many 'buildings'
nextbuilding:
            ;ld    l,b                    ; pseudo random bit of rom
            ;ld    a,(score+1)            ; starting at H=2 is better than 0 - can randomize this from score, later
            ;inc   a
            ;ld    h,a                    ; this is based on score LSB
            ;ld    a,(hl)                 ; get a number

            call   rand_8                 ; random 8 bit number
            and   %111                   ; from 0-7
            inc   a                      ; from 1-8

            push  de                      ; store attr location
            ex    de,hl                   ; move that into HL
            ld    c,a                     ; the counter c is (A) is the height
            ;ld         a,9+128           ;flashing blue on blue colour
            ;and    %111

nextbuildingfloor:
            ld    a,c                           ; colour will be based on height

            dec a                         ;
            cp %111                             ; just ink
            jr nz,notblack                ;
            ld a,%110                     ; make black 111 become blue 110 (they are inverted later)
notblack:
            and %111                      ; mask out just the ink
            ld      (hl),a                ; write the colour
            rla
            rla
            rla                                 ; rotate ink into paper position
            or    (hl)                    ; combine
            xor   %111111                   ; invert the bits
            or    %1000000                  ; add the flash bit
            ld    (hl),a                    ; write the colour
            ld    de,32                   ; move one row above by
            sbc   hl,de                   ; take 32 from the attr
            dec   c                             ; decrese height counter
            jr    nz,nextbuildingfloor
            pop   de                            ; restore address
            inc   de                            ; increase it
                  djnz  nextbuilding            ; move to next 'building'

planeloop:
                  ld          hl,(planepos)
                  push        hl
                  call        HL_POSITION_INTO_HL_ADDR
                  ld          (hl),0
                  pop         hl
                  push        hl
                  inc         hl
                  call        HL_POSITION_INTO_HL_ADDR
                  ld          (hl),56+7
                  pop         hl
                  ld          de,22
                  add         hl,de
                  push        hl
                  call        HL_POSITION_INTO_HL_ADDR
                  ld          (hl),0
                  pop         hl
                  inc         hl
                  push        hl
                  call        HL_POSITION_INTO_HL_ADDR
                  ld          (hl),56+7
                  pop         hl
                  inc         hl
                  push        hl
                  call        HL_POSITION_INTO_HL_ADDR
                  ld          (hl),56+7
                  pop         hl
                  inc         hl
                  call        HL_POSITION_INTO_HL_ADDR
                  ld          a,(hl)                              ; did nose of plane hit anything?
                  or          a                                   ; is the air infront of plane clear?
                  jp          nz,planehitsomething
                  ld          (hl),56+7


                  ld          hl,(planepos)
                  inc         hl                                  ;     check for crash/end of level *
                  ld          (planepos),hl


                  ld          hl,(bombpos)
                  ld          a,l
                  or          h
                  jr          z,nobomb                ; no bomb in air, so skip bomb routine

                                                                  ; draw bomb, and update bombpos *
                  ld          hl,(oldbomb)
                  ld          (hl),0                        ; clear old bomb from screen
                  ld          hl,(bombpos)
                  ld          de,22
                  add         hl,de                   ; move bomb lower
                  ld          (bombpos),hl            ; store new bomb position           ; check for hit / end of screen *
                  call        HL_POSITION_INTO_HL_ADDR
                  ld          a,(hl)
                  or          a
                  jr          nz,bombhitsomething           ; either hit floor or building
                  ld          (hl),2*8+2              ; draw red bomb
                  ld          (oldbomb),hl            ; store old bomb screen address
                  jr          disable_fire            ; can't drop another bomb, so skip it
nobomb:
                  ld          bc,32766                ; B, N, M, Symbol Shift, Space
                  in          a,(c)
                  cpl                                       ;
                  and         %101                    ; consider M and Space
                  jr          z,firenotpressed  ; if it's being pressed


                                                                  ; DROP A Bomb (SFX and set up bombpos) *
                  ld          hl,(planepos)           ; get position
                  ld          de,45
                  add         hl,de
                  ld          (bombpos),hl            ; store initial bomb position
                  call  HL_POSITION_INTO_HL_ADDR
                  ld          a,(hl)
                  cp          0
                  jp          nz,bombhitsomething
                  ld          (hl),2*8+2              ; red bomb launch
                  ld          (oldbomb),hl            ; store old bomb screen address
disable_fire:
firenotpressed:

planedelay:
                  ld          b,100
pause6:           ld          c,100
pause5:           dec         c
                  jr          nz,pause5
                  djnz        pause6

easymod4:          nop

                  jp          planeloop


bombhitsomething:                   ; bomb hit SOMETHING
            and     %1000000  ; is it bright (ie is it the floor)

            jr          nz,bombhitabuilding
                                                ; bomb hit floor
            ld          hl,0        ; remove the bomb
            ld          (oldbomb),hl
            ld          (bombpos),hl
                              ; also need to remove tail - not sure why!
            ld          hl,(planepos)
            call  HL_POSITION_INTO_HL_ADDR
            ld          (hl),167
            jp          planedelay

bombhitabuilding:
            ld          a,(hl)          ; get colour of building hit
            push  af                ; store it for sfx
            ld    (hl),0            ; clear top of building
            and   %111        ; just ink
            xor   %111        ; white=000 blue=110
            inc   a                 ; now 1 - 7
            ld    hl,10           ; calculate score for this hit
                  or          a                 ; clear carry flag
doublescore:
            rl          l
            rl          h
            dec         a
            jr          nz,doublescore ; hl now is 20,40,80,160,320,640,1280

            ld          de,(bombscore)
            add         hl,de
            ld          (bombscore),hl
                                          ; add HL to score
            call  display_HL;
                                ; print score

            ld          hl,0        ; remove the bomb
            ld          (oldbomb),hl
            ld          (bombpos),hl

            pop         af
            and         %111        ; limit 0-7
            xor         %111
            inc   a
            rla         
            rla                                                                                
            ld          (noise0-1),a      ; set up crashfx to be small click
            ld          a,25
            ld          (noise+1),a
            call  crashsfx
           
            or          a                 ; clear carry flag
           
                  jp          planedelay

planehitsomething:                        ; plane hit SOMETHING
                  cp          9                 ; (is it the floor?)
                  jr          nz,planehitabuilding
                                                ; plane hit floor
                                                ; acknowledge this somehow
planehitabuilding:                        ; or a building
                  
                  ld          hl,0
                  ld          (oldbomb),hl
            ld          (bombpos),hl      ; clear any bombs for next game

            ld          a,250
            ld          (noise+1),a
            ld          a,90
            ld          (noise0-1),a      ; set up crashfx to be big
            call  crashsfx

end_of_citybomber:

                  ld          bc,(bombscore)
                  call        scoreswap
                  call        fade_to_wall

                  ld          hl,(score)
                  
                  call  display_HL
                  ld          b,100
pause4:           ld          c,100
pause3:           dec         c
                  jr          nz,pause3
                  djnz  pause4

                  call  colourcompass
                  call        increaseminigames ; increase number of minigames played, and draw more if needed
                  jp          loop        ; return to maze


bombscore:  defw 00
planepos:   defw 40
bombpos:    defw 0
oldbomb:    defw 0                  

;---- 
; END OF BOMB GAME
;----


;------ ------
; THIS TURNS THE HL POSITION into THE ATTRIB ADDRESS
;-------------
HL_POSITION_INTO_HL_ADDR:

                  ld          b,0         ; This routine is HL - the position through the screen
                  ld          de,22       ; [i.e. the steps] through screen
divloop:
                  inc         b
                  sbc         hl,de
                  jr          nc,divloop

                  dec         b                 ; b now has the 'y coordinate'

                  add         hl,de       ; hl now has remainder
                  ld          c,l         ; c is the 'x coordinate'

                  ld          de,32       ; this turns BC coordinate into the 'postion' into HL
                  ld          hl,0

mult:       dec         b
                  jr          z,multdone
                  add         hl,de
                  jr          mult
multdone:
                  ld          e,c
                  ld          d,0
                  add         hl,de

                  ld          de,$5800+32+1
                  add         hl,de       ; HL now has the screen attribute address

                  ret

;--------------------
;     display_HL    - print the big number, at the side
;     display_HL_CENTRE - print the big number, in the centre
;---------------------

display_HL_CENTRE:
           ex   de,hl
           ld   hl,$5800+32*13+17 ; units  - position in display file for...
           ld   (positiondigit1),hl
           ld   hl,$5800+32*13+12 ; tens
           ld   (positiondigit2),hl
           ld   hl,$5800+32*13+7  ; hundreds
           ld   (positiondigit3),hl
           ld   hl,$5800+32*13+2
           ld   (positiondigit4),hl
           ex   de,hl
           jr   checkitislessthan9999

display_HL:
           ex   de,hl
           ld   hl,$5800+32*19+28 ; units  - position in display file for...
           ld   (positiondigit1),hl
           ld   hl,$5800+32*13+27 ; tens
           ld   (positiondigit2),hl
           ld   hl,$5800+32*7+26  ; hundreds
           ld   (positiondigit3),hl
           ld   hl,$5800+32+25
           ld   (positiondigit4),hl
           ex   de,hl
checkitislessthan9999:
           push hl
easymod6:  ld   de,9999                        ; check the limit                        - - - - - - -------------------------------- this will be 9999
           sbc  hl,de ; no carry flag if HL>9999
           pop  hl
           jr   c,draw_big_number             ; if it's under the limit draw it
printexit_word:
               ld   hl,diagexit
               call printdiagword
               jr   prinrhtenumber_word

draw_big_number:
                  xor         a
                  ld          de,thous
                  ld          (de),a
                  ld          de,hunds
                  ld          (de),a
                  ld          de,tens
                  ld          (de),a
                  ld          de,units
                  ld          (de),a


                  ld          de,1000
                  xor         a           ; clear carry flag, and a
thouloop:         or          a           ; clear carry flag
                  sbc         hl,de
                  jr          c,thoudone
                  jr          z,exactly1000
                  inc         a
                  jr          thouloop
thoudone:         add         hl,de
thoudone1:        ld          (thous),a
                  ld          de,100
                  xor         a
hundloop          or          a           ; clear carry flag
                  sbc         hl,de
                  jr          c,hunddone
                  jr          z,exactly100      ; exactly a multiple of 100
                  inc         a
                  jr          hundloop
hunddone:         add         hl,de
hunddone1:        ld          (hunds),a
                  ld          de,10
                  xor         a
tenloop:          or          a           ; clear carry flag
                  sbc         hl,de
                  jr          c,tendone
                  jr          z,exactly10 ;     exactly multiple of 10.
                  inc         a                 ;
                  jr          tenloop           ;
tendone:          add         hl,de       ;
tendone1:         ld          (tens),a    ;

                  LD          A,L         ; L not a 1
                  ld          (units),a


prinrhtenumber_word:
                  ld          hl,(positiondigit1)
                  call        display_digit
                  ld          a,(tens)
                  ld          hl,(positiondigit2)
                  call        display_digit
                  ld          a,(hunds)
                  ld          hl,(positiondigit3)
                  call        display_digit
                  ld          a,(thous)
                  ld          hl,(positiondigit4)
                  call        display_digit
                  ret

exactly10:
                  inc         a
                  jr          tendone1
exactly100:
                  inc         a
                  jr          hunddone1
exactly1000:
                  inc         a
                  jr          thoudone1



thous:            defb  0
hunds:            defb  0
tens:             defb  0
units:            defb  0

positiondigit1: defw $5800+32*19+28 ; units  - position in display file for...
positiondigit2: defw $5800+32*13+27 ; tens
positiondigit3: defw $5800+32*7+26  ; hundreds
positiondigit4: defw $5800+32+25    ; thousands

diagexit:       defb  "EXIT"

printdiagword:
           ld   a,(hl)
           sub   "0"                     ;     it is large set it up with the word EXIT
           ld   de,thous
           ld   (de),a
           inc  hl
           ld   a,(hl)
           sub  "0"
           ld   de,hunds
           ld   (de),a
           inc  hl
           ld   a,(hl)
           sub  "0"
           ld   de,tens
           ld   (de),a
           inc  hl
           ld   a,(hl)
           sub  "0"
           ld   de,units
           ld   (de),a

           ret

;-------------------
;DISPLAY DIGIT a : called with HL pointing at the place on screen   digit/character
;---------------------
display_digit:
                  push  hl
                  or          a           ;clear carry flag
                  ld          e,a
                  ld          d,0
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  ld          l,a
                  ld          h,0
                  add         hl,de
                  ld          de,number_font
                  add         hl,de       ; hl now points at the table
                  pop         de                ; de points to the sceen


                  ld          c,5
nextcolumn:       ld          b,4
                  ld          a,(hl)
nextbit:
                  rla
                  push  af
                  jr          nc,drawnobit
colourmod:        ld          a,7*8+7           ; SMC coulourmod+1 to change digit colour
                  jr          drawbit
drawnobit:
                  ld          a,0
drawbit:          ld          (de),a
                  pop         af
                  inc         de
                  djnz  nextbit
                  inc         hl
                  push  hl
                  ld          hl,32-4
                  add         hl,de
                  ex          de,hl
                  pop         hl    
                  dec         c
                  jr          nz,nextcolumn
                  ret

scroll_attr_down:                         ; scrolls attribs down one line
                  ld          hl,5800h+32+1+32
                  ld          de,5800h+32+1
                  ld          c,21
scr_nxtlin: ld          b,22                                                              
scr_nxtchr: ld          a,(hl)
                  ld          (de),a
                  inc         hl
                  inc         de
                  djnz  scr_nxtchr
                  push  de
                  ld          de,10
                  add         hl,de
                  pop         de
                  push  hl
                  ld          hl,10
                  add         hl,de
                  ex          de,hl
                  pop         hl
                  dec         c
                  jr          nz,scr_nxtlin
                  ret
                  

;----------------
;FADE TO WALL
;----------------
fade_to_wall:
                  ld    a,%111
                  ld    (coltunsmc+1),a
                  ld    a,(frontcol)            ; make it 'wall coloured'
                  ld    (tocolour+1),a

                  ld          de,(ycoord)
                  ld          hl,aheadofus
                  call  addvector
                  call  getpos_in_maze
                  ld    (hl),4                  ; make it just an expired game
                  jr    colour_tunnel                             

;----------------
;FADE TO WHITE
;----------------
fade_to_white:
                  ld    a,0
                  ld    (coltunsmc+1),a
                  ld    a,0
                  ld    (tocolour+1),a
                  jr    colour_tunnel

;----------------
;FADE TO BLACK
;----------------
fade_to_black:
                  ld    a,%111
                  ld    (coltunsmc+1),a
                  ld    a,0
                  ld    (tocolour+1),a
                  jr    colour_tunnel                       
                  
;-----------
; MINI SCREEN colour tunnel
;------------
colour_tunnel:
                  ld          b,0
                  ld          c,0
colourbox_loop:

                  ld          a,b
                  push  bc
                  and         %111
                  or          c
coltunsmc:  xor         %111        ; this is 111 if going to black.  0 if going to white
tocolour:   or          0                 ; zero normally, dieffernt if going to a colour
                  ld          c,a
                  rla         
                  rla
                  rla
                  or          c           ;     a= colour
                  ld          c,b         ;     b,c=position
                  
                  ld          d,0
                  ld          e,b
                  
                  or          a           ; clear cf
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  rl          e
                  rl          d
                  rl          e
                  rl          d           ; x32
                  ld          hl,$5800+32+1
                  add         hl,de
                  ld          e,c
                  ld          d,0
                  add         hl,de
                  push  af
                  ld          a,11
                  sub         b     
                  or          a
                  rl          a           ; x2
                  ld          b,a
                  ld          c,a
                  pop         af

                  call  colourbox               ;'colour a box' at HL of size B,C, colour a     
                  pop         bc


                  inc         b
                  ld          a,b
                  cp          11
                  jr          nz,   colourbox_loop
                  inc         c
                  ld          a,c
                  halt
                  halt
                  halt
                  ld          b,0
                  cp          8
                  jr          nz,colourbox_loop

                  ret

number_font:                                          ; everything is top left justified
numbers:
            defb  240,144,144,144,240
            defb  96,160,32,32,240
            defb  240,16,240,128,240
            defb  240,16,240,16,240
            defb  144,144,240,16,16
            defb  240,128,240,16,240
            defb  240,128,240,144,240
            defb  240,16,16,16,16
            defb  240,144,240,144,240
            defb  240,144,240,16,16
letters:
            defb  0,96,0,96,0               ; : colon
            defb  0,0,0,0,80                ; ; elipsis
            defb  48,95,192,96,48           ; < less then
            defb  0,0,240,0,0               ; = equals - used as hyphen
            defb  192,96,48,96,192          ; > greater than
            defb  249,144,32,0,32           ; ? question mark

            defb  0,0,0,0,0                     ; "at sign chr" chr$ 64, serves as 'space'
            defb  240,144,240,144,144           ;  A
            defb  240,144,224,144,240
            defb  240,128,128,128,240
            defb  224,144,144,144,224
            defb  240,128,224,128,240
            defb  240,128,224,128,128
            defb  240,128,176,144,240           ;   G
            defb  144,144,240,144,144
            defb  240,96,96,96,240        ; I
            ;defb 224,64,64,64,224        ; other i
            defb  16,16,144,144,240
            defb  144,144,224,144,144
            defb  128,128,128,128,240
            defb  144,240,240,144,144
            defb  144,208,176,144,144
            defb  240,144,144,144,240
            defb  240,144,240,128,128           ;     P
            defb  240,144,144,160,208
            defb  240,144,224,144,144
            defb  240,128,240,16,240
            defb  240,96,96,96,96         ; T
            defb  144,144,144,144,240
            defb  144,144,160,192,128
            defb  144,144,240,240,144     ; W
            defb  144,96,96,144,144       ; X
            defb  144,144,240,16,240      ; Y
            defb  240,32,64,128,240       ; Z



;--------------------------------------------------------------------------
;SOUNDFX    - there's some self modifying code here! noise+1 and noise0-1, set it up before you call!
;----------------------------------------------------------------------------
crashsfx:
noise  ld e,25            ; repeat 250 times. 250 is given example
       ld hl,0             ; start pointer in ROM.
noise2 push de
       ld b,9            ; length of step.      32 is given example
noise0 push bc
       ld a,(hl)           ; next "random" number.
       inc hl              ; pointer.
       and 248             ; we want a black border.
       out (254),a         ; write to speaker.
       ld a,e              ; as e gets smaller...
       cpl                 ; ...we increase the delay.
noise1 dec a               ; decrement loop counter.
       jr nz,noise1        ; delay loop.
       pop bc
       djnz noise0         ; next step.
       pop de
       ld a,e
       sub 24              ; size of step.
       cp 30               ; end of range.
       ret z
       ret c
       ld e,a
       cpl
noise3 ld b,40             ; silent period.
noise4 djnz noise4
       dec a
       jr nz,noise3
       jr noise2
         ret


;-----------------------------
;PLAY A MINIGAME - SNAKE
;-----------------------------
minigame3:
           call  clearcolourcompass;
           call  fade_to_black

                                                      ; edgecase fix when there are two adjacent black games
           ld    hl,$5800+32                          ; left wall
           ld    a,(hl)
           or    a                                    ; is is black
           jr    nz,checkrightedge                    ; if not, move on
           ld    de,32                                ; one row
           ld    b,22                                 ; copy into 22 block
edgeloop1: ld    (hl),64                              ; bright black
           add   hl,de                                ; one row down
           djnz  edgeloop1
checkrightedge:
           ld    hl,$5800+32+23                       ; right wall
           ld    a,(hl)
           or    a                                    ; is is black
           jr    nz,finishededgechecking              ; if not move on
           ld    de,32                                ; one row
           ld    b,22                                 ; copy into 22 block
edgeloop2: ld    (hl),64                              ; bright black
           add   hl,de                                ; one row down
           djnz  edgeloop2
finishededgechecking:                                 ; end of edgecasechecking

           ld    hl,minigame3message
           call  bigready                        ; print the ready message
           ld    hl,jingle3
           call  playjingle   ; play jingle 3

         ;  call debug
           ld          hl,0
           ld          (snakescore),hl
           ld          hl,snakelength    ; set start length
           ld          (hl),7
           ld          de,$ff00          ; set snake direction         (upwards)
           inc         hl
           ld          (hl),e
           inc         hl
           ld          (hl),d
           ld          de,$0d0A          ; set snakehead startpos
           ld          a,8
populatebody:
           inc         hl
           ld          (hl),e
           inc         hl
           ld          (hl),d
           inc         d                 ; one row lower
           dec         a
           jr          nz,populatebody
           call        clear_mini_screen

           call        drawthesnake    ; draw the snake
           call        drawsnakefood   ; draw the food

snakeloop:
           halt
           halt
easymod3:  nop
           halt        ; slowdown
;

           call        drawthesnake


;read keys
       ld bc,57342         ; keyboard row POIUY
       in a,(c)            ; see what keys are pressed.
       rra                 ; outermost bit = key P.
       ld d,a              ; remember the value.
       jr nc,snakeright    ; it's being pressed, move right.
       ld a,d              ; restore accumulator.
       rra                 ; next bit along (value 2) = key O.
       jr nc,snakeleft     ; being pressed, so move left.

       ld bc,64510         ; keyboard row QWERT
       in a,(c)            ; see what keys are pressed.
       rra                 ; outermost bit = key Q.
       jr nc,snakeup        ; it's being pressed, turn up

       ld bc,65022         ; keyboard row ASDFG
       in a,(c)            ; see what keys are pressed.
       rra                 ; outermost bit = key A.
       jr nc,snakedown   ; it's being pressed, turn down



       jr    directiondone  ;nochangeindirection
snakedown:
       ld   hl,$0100
       jr   directionset
snakeup:
       ld   hl,$ff00
       jr   directionset
snakeleft:
       ld   hl,$00ff
       jr   directionset
snakeright:
       ld   hl,$0001
directionset:
       ld    a,(snakedirection)
       add   a,l
       jr    z,directiondone    ; can't go back on itself
       ld    a,(snakedirection+1)
       add   a,h
       jr    z,directiondone    ; can't go back on itself
       ld    (snakedirection),hl
directiondone:


;move the head
      ld      de,(snakehead)
      push    de                ;save the head position
                                    ;updatesnakedata table
       ld   hl,endofsnakedata-4
       ld   de,endofsnakedata-2
       ld   bc,512                  ;length of data to move
       lddr                         ;pushes the data down the table
                                    ;end of updatesnaketale
      pop     de               ;restore the head



;update position of head, based upon direction

      ld      hl,(snakedirection)
      ld      a,d
      add     a,h
      ld      d,a

      ld      a,e
      add     a,l
      ld      e,a
      ld      (snakehead),de

;check for collision / eating
       ld     a,d
       cp     0                               ; top wall
       jr     z,hitwallorself
       call   DE_COORDS_TO_HL_ADDR
       ld     a,(hl)                          ; what is in the cell we're about to move into?
       cp     0                                ;is is black?
       jr     nz,hitsomething
       jr     hitnothing

hitsomething;
       cp    4+4*8+64                               ; is it bright green
       jr    z,hitsomefood                          ; if so - that's food - lets go and do something about that
hitwallorself:
       ld          a,250
       ld          (noise+1),a
       ld          a,90
       ld          (noise0-1),a      ; set up crashfx to be big
       call  crashsfx
       jp end_of_snake   ; exit the snake game

hitsomefood:

                                 ; make some noise
       ld       b,50
beeploop:
       ld       a,255
nextcycle:
       dec      a
       and      248
       out      (254),a
       or       a
       jr       nz,nextcycle
       djnz     beeploop



                                  ; update score
       ld       hl,(snakescore)
       ld       a,(snakelength)
       ld       e,a               ; add on the length of snake to score?
       ld       d,0
       add      hl,de
       ld       (snakescore),hl
       call     display_HL           ; show score





       ld       a,(snakelength)   ; increase the snake length
       inc      a                 ;
       jr       c,snakemax        ; unless it is already 255
       ld       (snakelength),a   ;

       call     drawthesnake

       call     drawsnakefood     ; draw some new food



snakemax:

hitnothing:
     jp snakeloop    ; loop round!




; draw the snake routine [draws the contents of the snakesnake data area]
drawthesnake:
            ld          a,(snakelength)         ; get current length of snake
            ld          b,a                     ; counter for length
            ld          (SMCHEAD+1),a           ; self mdifying code for colouring head a different colour

            ld          hl,snakehead            ; start with head position
nextbitofsnake:
            ld          e,(hl)                  ; load co-ords into DE
            inc         hl
            ld          d,(hl)
            inc         hl                      ; ready for next position
            push        hl                      ; store position of body pointer
            push        af                      ; store counter
            call        DE_COORDS_TO_HL_ADDR    ; turn coordinates into position in attribute dasiplay
            ld          a,b
SMCHEAD:    cp          255                     ; this Self Modifying Instruction is checking if it is the head
            jr          z,itisthehead           ; skip setting up the colour if it ths the head
            rrca                                ; lowest bit becomes bright bit
            rrca
            and         %1000000               ; just bright bit
            or          %0011011               ; magenta
            jr          drawthebodypart
itisthehead:
            ld          a,%10010010             ; bright red
drawthebodypart:
            ld          (hl),a
            pop         af                      ; restore the counter
            pop         hl                      ; restore the next body position
            djnz        nextbitofsnake
            ld          e,(hl)                  ; sort out the end of the tail
            inc         hl
            ld          d,(hl)
            call        DE_COORDS_TO_HL_ADDR    ; turn coordinates into position in attribute dasiplay
            ld          (hl),0                  ; blank the end of snake
            ret
;end of draw the snake routine

; exit rhe snakeminigame
end_of_snake:

                  ld          bc,(snakescore)
                  call        scoreswap


                  call        fade_to_wall
                  ld          hl,(score)
                  call        display_HL
                  ld          b,100
pause10:
                  ld          c,100
pause9:
                  dec         c
                  jr          nz,pause9
                  djnz        pause10

                  call        colourcompass
                  call        increaseminigames ; increase number of minigames played, and draw more if needed
                  jp          loop        ; return to maze

drawsnakefood:                          ; randomly draws food on a space on the playfield
rndloop:
           call        rand_1to22
           ld          e,a
           call        rand_1to22
           ld          d,a
           call        DE_COORDS_TO_HL_ADDR
           ld          a,(hl)
           or          a
           jr          nz,rndloop
           ld          (hl),64+4+4*8
           ret


snakescore: defw 00
snakelength:
                  defb 7
snakedirection:
                  defw $0100
snakehead:        defw $0A10                                                         ; THIS HAS TO BE JUST BEFORE THE BODY SPACE
snakebody:
SCRATCHATTR:                                                                        ; THIS IS USED AS THE SCREEN BUFFER FOR MAZE AND FOR FLAPI BLOCK
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0                             ; stores position of body   ;16
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0                             ;32
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0                             ;
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0                             ;64

                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0                             ;128

                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0

                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0                             ;max length of snake - 256 segments! (this is 512 byte table)
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0
                  defw 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0                             ;256 (512 bytes, 256 addresses)
endofsnakedata:
                  defs 256,0                                                        ; pad buffer to 768 bytes  - NEEDED for the BACK BUFFERED SCREEN



;--------------------------------------------------------
;D,E coordinates (from top) E=horizontal, into HL screen address
;--------------------------------------------------------
DE_COORDS_TO_HL_ADDR:
                  ld          hl,$5800 ;+32
                  push  de
                  ld          d,0
                  add         hl,de
                  pop         de
                  ld          a,d
                  ld          de,32
coordadds:
                  add         hl,de
                  dec         a
                  jr          nz,coordadds
                  ret

;------------------------------------
;RANDOM NUMBER ROUTINE STUFF
;----------------------------------------
r_seed:
	Defw	1			; prng seed byte (must not be zero)

;-----------------------------------
;CALL HERE FOR A RND NUMBER 1 - 22
;-----------------------------------
rand_1to22:
; for a number between 1 and 22
nextnum:
        call	rand_8
        and		%11111	; 0 - 31
	inc		a		; 1 -32
        cp		23
        jr		nc,nextnum	; reject it if over 23 or over
	ret
;end of useful routine

; returns pseudo random 8 bit number in A. Only affects A.
; (r_seed) is the word from which the number is generated.
rand_8:
random:
        push    hl
        push    de
        ld      hl,(r_seed)
        ld      a,r
        ld      d,a
        ld      e,(hl)
        add     hl,de
        add     a,l
        xor     h
        ld      (r_seed),hl
        pop     de
        pop     hl
        ret


rand_0to32:       ; for a number between 0 and 32
        call	rand_8
        and	%11111	; 0 - 31
	ret


;---------------------------------------------------------------------
; random place for player, thus place we're starting in. We'll set this up.
;ycoord            defb  2           ; player position
;xcoord            defb  3           ; from left
;aheadofus         defb  0,1         ; direction we're moving/looking in
;-------------------------------------------------------------------------
randomplayerpos:
        call    rand_1to22
        and     %111      ; limit it to top three rows, for now
        ld      e,a
        call    rand_0to32
        ld      d,a
        ld      (ycoord),de
        call    getpos_in_maze   ; Turns DE into HL memory addess in maze
        xor     a
        or      (hl)
        jr      nz,randomplayerpos ; if it's not empty - we need another position
        call    rand_8 ; random number for direction
        and     %11    ; four directions
        inc     a
        ld      b,a
keeprotatingmore:
         call    spintheplayer
         djnz    keeprotatingmore
checkiffacingwall:                         ; check if the player is facing a wall, then spin until they aren't
         ld          de,(ycoord)
         ld          hl,aheadofus
         call        addvector
         call        getpos_in_maze
         ld          a,(hl)
         or          a
         ret         z
         call        spintheplayer
         jr          checkiffacingwall


spintheplayer:
                  ld          a,(frontcol)                  ; turn left
                  ld          c,a
                  ld          a,(leftcol)
                  ld          (frontcol),a
                  ld          a,(backcol)
                  ld          (leftcol),a
                  ld          a,(rightcol)
                  ld          (backcol),a
                  ld          a,c
                  ld          (rightcol),a


                  ld          hl,(aheadofus)              ; rotate view
                  ld          de,(leftofus)
                  ld          (aheadofus),de
                  ld          de,(behindus)
                  ld          (leftofus),de
                  ld          de,(rightofus)
                  ld          (behindus),de
                  ld          (rightofus),hl
                  ret

;------
; end of random player pos
;---------


;---------------------------------------------------------------------
; random place for MINIGAME
; two entry points:
;                  randomdoorpos24 - sets a MINIGAME somewhere
;                  randomdoorpos8 - sets a MINIGAME in the top 8 rows
;                  returns with HL pointing at a VALID WALL SPACE for a MINIGAME or EXIT
;-------------------------------------------------------------------------
lrvalidflag:    defb 0  ; flags to check about validity of placement
udvalidflag:    defb 0

randomdoorpos24:                   ; set up to do the whole of the screen
        ld     a,%11111111
        ld     (randpossmc+1),a
        jr     randomdoorpos

randomdoorpos8:                   ; set up to do the whole of the screen
        ld     a,%111
        ld     (randpossmc+1),a
        jr     randomdoorpos

randomdoorpos:
        ld      hl,0
        ld      (lrvalidflag),hl ; reset left-right/up-down validity flags both to 0

        call    rand_0to32
        cp      24        ; limit to top 23 rows of maze
        jr      nc,randomdoorpos
randpossmc:
        and     %111       ; limit to the top 8 rows (for initial setup) IS MODIFIED by the call point for this routine

        ld      e,a
        call    rand_0to32
        ld      d,a

        call    getpos_in_maze   ; Turns DE into HL memory addess in maze
        ld      a,1              ; is it a wall (unused, normal wall). i.e. a 1 (one)
        xor     (hl)
        jr      nz,randomdoorpos ; if it's not wall - we need another position
                                 ; may be valid as a minigame
                                 ; test if there is a wall either side (left right)
        dec     hl
        ld      a,(hl)
        inc     hl
        cp      1
        jr      nz,testupdownwall
        inc     hl
        ld      a,(hl)
        dec     hl
        cp      1
        jr      nz,testupdownwall
        ld      a,1
        ld      (lrvalidflag),a  ; it has wall to the left AND right
testupdownwall:
        push   hl  ; save the mazepos
        ld     de,32
        or     a               ; clear carry flag
        sbc    hl,de                                                                   
        ld     a,(hl)
        cp     1
        jr     nz,endoftesting
        ld     de,64
        xor    a
        add    hl,de
        ld     a,(hl)
        cp     1
        jr     nz,endoftesting
        ld     a,1
        ld     (udvalidflag),a  ; it has wall to the above AND below
endoftesting:
        ; one, OR the other, MUST be valid (but not both)
        ld     a,(udvalidflag)
        ld     hl,lrvalidflag
        xor    (hl)
        pop    hl   ; restore the mazepos
        jr     z,randomdoorpos

        ; must check at least one is a path, can be trapped by other panels
        push   hl             ; store proposed panel address
        dec    hl               ; check left
        ld     a,(hl)
        or     a
        jr     z,validforpanel
        inc    hl
        inc    hl
        ld     a,(hl)           ; check right
        or     a
        jr     z,validforpanel
        ld     de,31            ; check below
        add    hl,de
        ld     a,(hl)
        or     a
        jr     z,validforpanel
        ld     de,64
        sbc    hl,de            ; check above
        ld     a,(hl)
        or     a
        jr     z,validforpanel
        pop    hl               ; clear stack
        jr     randomdoorpos


validforpanel:
        pop    hl               ; restore HL
        ret
;------
; end of random place minigame
;---------


;--------------------------------
; big text  - called with HL pointing at string, terminated with 255
;--------------------------------

bigtextcoords:
              defw $0202             ; Co-ordinates on screen
brightflag:   defb 0                 ; brightflag
textcolour:   defb 7*8+7             ; colour (green)

;----- enter here

bigtext:
              xor   a
              ld    (brightflag),a
bigtextloop:
              ld   a,(textcolour)    ; set up colour for printing
              ld   c,a
              or   a                 ; clear carry flag
              rla
              rla
              rla
              or c                   ; ink paper same
              ld   a,(brightflag)
              and  %01000000
              or   c
              ld   (colourmod+1),a

              ld   a,(hl)
              cp   255
              jr   z,endbigtext

              push hl
              ld   de,(bigtextcoords)
              push de
              push af
              call DE_COORDS_TO_HL_ADDR
              pop  af
              cp    32                 ;is it space
              jr    nz,notaspace
              ld    a,"@"              ; if it is use character @
notaspace:
              sub  "0"

              call display_digit

              pop  de
              inc  e
              inc  e
              inc  e
              inc  e
              ld   a,e
              cp   19
              jr   c,nextletterfits

              ld   e,2
              inc  d
              inc  d
              inc  d
              inc  d
              inc  d
              ;ld   a,(brightflag)                ; toggle brightflag
              ;cpl                                ;
              ;ld   (brightflag),a                ;
nextletterfits:
              ld   (bigtextcoords),de
              pop  hl
              inc  hl

              ld   a,(brightflag)                ; toggle brightflag
              cpl
              ld   (brightflag),a
              jr   bigtextloop
endbigtext:
              ld   a,7*8+7
              ld   (colourmod+1),a
              ret

;demo bidtext message used for debugging
;bigtext_message:
           ;    defb "ATTR  MAZEWOOT  2022",255


;print big ready message at start of minigame
bigready:
                push hl
                ld   hl,0
                call display_HL
                
                ld    a,(practiceflag)
                cp    1                      ; is it a pracicegame
                jr    nz,nolearn             ; if not, ignore this

                ld   de,0202h                ; at 3,2
                ld   (bigtextcoords),de
                ld   hl,learnmessage
                ld   a,255
                ld   (brightflag),a
                call bigtextloop

nolearn:
                pop  hl

                ld   de,0702h
                ld   (bigtextcoords),de
                call bigtext
                ret

minigame1message: defb "DODGE","WALLS",255
minigame2message: defb "DROPS","BOMBS",255
minigame3message: defb "SNAKE","BITES",255
minigame4message: defb "FLAPI","BLOCK",255
scoreswapmessage: defb "TOTAL",255
learnmessage: defb "LEARN",255

;print big score message at end of minigame
bigscore:       ld   hl,0206h
                ld   (bigtextcoords),hl
                ld   hl,messagescore
                call bigtext
                ret
messagescore:
                defb "SCORE",255



;---------------------------
;keydebounce - wait for all keys not to be pressed
;--------------------------
keydebounce:
                push af
keydebounceloop:
                XOR   A
                IN    A,($FE)
                CPL
                AND   $1F
                JR    NZ,keydebounceloop
                pop   af
                ret



;-------------------------------------------------------
;MAP
;-------------------------------------------------------


map:
       ld   a,1              ; blue border
       out  (254),a
       ld   hl,mapuse
       inc  (hl)             ; mapuse goes up by one
       ld   de,(ycoord)
       call getpos_in_maze   ; de-gives HL pointing at maze position
       ld   a,255            ; temp mark place in maze where we are
       ld   (hl),a


       ld bc,32*24
       ld hl,maze
       ld de,5800h  ; attributes
maploop
       ld a,(hl)
       or a
       jr z,writemapbox
mapisitwall
       cp  1 ; wall
       jr  nz,mapisitpanel
       ld  a,1*8+1+64 ; bright blue
       jr  writemapbox
mapisitpanel;
       cp  2 ; minigame
       jr  nz,mapisitdeadpanel
       ld  a,7*8+7+64 ; bright white
       jr  writemapbox
mapisitdeadpanel:
       cp  4 ; dead minigame
       jr  nz,mapisitexit
       ld  a,1*8+1+0 ; dull blue
       jr  writemapbox
mapisitexit
       cp  3 ; exit
       jr  nz,mapisitplayer
       ld  a,4*8+4+64 ; bright green
       jr  writemapbox
mapisitplayer:
       ld  a,5*8+5+64



writemapbox:
       ld (de),a

       inc hl
       inc de
       dec bc
       ld a,c
       or b
       jr nz,maploop

       ld de,(ycoord)
       call getpos_in_maze ; de-gives HL pointing at maze position
       xor a
       ld (hl),a


       call keydebounce                 ; if it's being pressed
       ld   a,0              ; blue border
       out  (254),a

       call clsblack

       call  colourcompass

       ld  hl,(score)        ; is the score 0
       ld  a,h
       or l
       ret z

       call  display_HL       ; if not, display it

       ret


;----------------------------------------------------------
; Increase the number of minigames, and draw more if multiple of four have been played
;------------------------------------------------------

increaseminigames:
       ld   hl,minigamesplayed
       ld   a,(hl)
       inc  a
       ld   (hl),a
       and  %11     ; is it a mutiple of four?
       cp   %00
       ret  nz      ; if it's not a mutiple of three, we're good

                                                            ; indicate we're adding more minigames

       ld   a,(exitingmazeflag)
       or   a
       ret  nz                                              ; return without increasing number of minigames if this is the exit the maze stage

       call randomdoorpos24
       ld     (hl),2       ; sets it to a MINIGAME
       call randomdoorpos24
       ld     (hl),2       ; sets it to a MINIGAME
       call randomdoorpos24
       ld     (hl),2       ; sets it to a MINIGAME
       call randomdoorpos24
       ld     (hl),2       ; sets it to a MINIGAME

       call  rand_8                              ; start with a random minigame
       and   %110  ; 0,2,4 or 6
       ld    (minigamechoice),a                  ; store the choice

       ret


;-----------------------------------------------
;CLS BLACK - clear screen to BLACK ON BLACK
;---------------------------------------------

clsblack:
       ld hl,5800h
       ld de,5801h
       ld (hl),0
       ld bc,32*24-1
       ldir
       ret


;-------------------------------------------------
; wait for keypress
;------------------------------------------------

waitforkeypress:
                XOR   A
                IN    A,($FE)
                CPL
                AND   $1F
                JR    NZ,keyispressed
                jr    waitforkeypress             
keyispressed:   ret


;-----------------------------------------------
; EXIT ROUTINE
; display time from FRAMES (least tignificant byte first) 23672
;------------------------------------------------
EXIT_routine:
                pop    hl  ;  CLEAR STACK

                call  fade_to_black

                ld   de,0202h
                ld   (bigtextcoords),de
                ld   hl,EXIT_message5
                call bigtext

                ld    hl,congratsjingle
                call  playjingle
                di                    ; stop the framse counter
                call   keydebounce
                call   waitforkeypress
                ei                    ; restore the frames counter
                ld   de,0202h
                ld   (bigtextcoords),de
                ld   hl,EXIT_message1
                call bigtext

                ld     hl,(23673)     ; frames into seconds ....
                ld     d,h
                ld     e,l
                add    hl,hl
                add    hl,hl
                add    hl,de          ; multiply by 5
                xor    a              ; clear carry flag
                rr     d
                rr     e              ; de/2
                xor    a              ; clear carry flag
                rr     d
                rr     e              ; de/4
                add    hl,de
                ld     a,(23673)
                rrca
                rrca                  ; a/4
                and    %00111111      ; ignore rotated bits
                ld     e,a
                ld     d,0
                add    hl,de          ; HL now has time in seconds (ish)

                push   hl             ; store the time in seconds

                call   display_HL

                call   keydebounce
                call   waitforkeypress

                call  fade_to_black

                ld   de,0202h
                ld   (bigtextcoords),de
                ld   hl,EXIT_message2
                call bigtext

                ld     a,(minigamesplayed)
                ld     l,a
                ld     h,0
                call   display_HL

                call   keydebounce
                call   waitforkeypress
                call   fade_to_black

                ld     de,0202h
                ld     (bigtextcoords),de
                ld     hl,EXIT_message3
                call   bigtext

                ld     a,(mapuse)
                ld     l,a
                ld     h,0
                call   display_HL

                call   keydebounce
                call   waitforkeypress

                call  fade_to_black


                ; calculate final score score
                ld     a,(minigamesplayed)             ; ganes *100
                ld     hl,0
                ld     d,0
                ld     e,a
                ld     b,100
multby100:      add    hl,de
                djnz   multby100

                ld     a,(mapuse)                      ; map use x 100
                ld     d,0
                ld     e,a
                ld     b,100
multby100b:     add    hl,de
                djnz   multby100b

lowestnotzero:
                pop     de       ; retrieve the time in seconds
                add     hl,de    ; add the 100 x sum of (maps + games)

                ld      de,10000 ;; max score, if you did it in 0 seconds
                ex      de,hl
                or      a       ; clear carry flag

                sbc     hl,de
                push    hl      ; save final score

                ld      de,0202h
                ld      (bigtextcoords),de
                ld      hl,EXIT_message4
                call    bigtext
                
                pop     hl     ; retrieve final score

                call    display_HL    ; print final score

                call    keydebounce
                call    waitforkeypress
                call    set_up_the_screen
                call    keydebounce

                jp      subsequentStart                 ; back to the menu
                ;ret   ; return to basic

EXIT_message5:  defb "YOUREGREATWELL  DONE",255
EXIT_message1:  defb "TIME           SECS ",255
EXIT_message2:  defb "MINI GAMES          ",255
EXIT_message3:  defb "MAP  USED      TIMES",255
EXIT_message4:  defb "FINALTOTALSCOREIS;;;",255


;--------------------------------------------
; MENU BUTTON PRESS NOISE
;------------------------------------------

squidgebleep:                                                ;make noise
                  ld de, 5                                  ;
                  ld b,3
                  ld hl, 938                                ; pitch
sound_loopy:
                  dec h
                  push bc
                  push de
                  push hl
                  call 949                                  ; call ROM beeper routine
                  pop hl
                  pop de
                  pop bc
                  djnz sound_loopy

                 ld hl,297           ; pitch.
                 ld de,208           ; duration.
                 call 949            ; ROM beeper routine.
                 ret

;-----------------------
;Tunes Stuff and UgliSynth
;-----------------------

;UGLISTEP SEQUENCER
;plays tunes




uglisynthstart_ug:
;            di
;            call    screensetup
;            ld      hl,jingle3        ;setup the song fragment
;            call    playsong            ;and play it
;
;            ei
;            ret


playopeningtheme:
             ld   a,1
             ld   (keypressflag),a    ; set up music routine to exit on keypress

             ld    a,16+1              ; 16+1(blue)
             ld   (musiccol2+1),a      ; set blue and blue clouur scheme
             ld    a,1                 ; 0+1(blue)
             ld   (musiccol1+1),a

             di
playagain:   ld   hl,openingthemejingle
             call playsong
             jr   z,playagain          ; zero flag will still be set if it got to end
             ei
             xor a
             out (254),a                 ; border black
dontplayagain:
             ld    a,16                ; 16+0(black)
             ld   (musiccol2+1),a      ; restore black and blue clouur scheme
             ld    a,1                 ; 0+1 (blue)
             ld   (musiccol1+1),a

             ld    a,0
             ld    (keypressflag),a    ; set up music routine to ignore keypress
             ret

playjingle:
           ld   a,(practiceflag)  
           or   a
           jr   z,playit              ; do play jingle on a practice game
           call keydebounce
           call waitforkeypress       ; instead wait for a keypress
           ret


playit:
            di
          ;  ld      hl,jingle3        ;setup the song fragment
            call    playsong            ;and play it

            xor a
            out (254),a                 ; border black

            ei
            ret

keypressflag: defb   0                   ; is the music routine quit with a keypress
playsong:   ;called with HL pointing at the musidata
            ld      (songpointer),hl ;prime the songpointer with the song fragment
testloop:
            ld   a,(keypressflag)
            or   a
            jr   z,ignorekeypressflag

            XOR   A                 ; check any key is being pressed
            IN    A,($FE)
            CPL
            AND   $1F
            RET    NZ               ; return if anything pressed

ignorekeypressflag:
            ld      hl,(songpointer)
            ld      (smc_data+1),hl
            inc     hl
            inc     hl
            ld      (songpointer),hl
smc_data:
            ld      hl,(0)
            ld      a,l           ;check if L (low byte) is zero (end of song marker), if so, return
            or      a
            ret     z



;Check for a 'rest' (is the value of H=0) 
            ld      a,h
            or      a
            jr      z,rest_routine 
 
            call    playnote 

   ;         jr      rest_routine  ;THIS IS INSERTING GAPS EACH TIME, FOR TESTING PURPOSES

            jr      testloop         ; Loop to next element in song 
 
; 
rest_routine:
            ld      bc,20000         ;insterts an audible gap THIS NEEDS TO BE BASED UPON length of L, ****but isn't, yet*** 
insert_pause:
            nop
            dec     bc 
            ld      a,b 
            or      c
            jr      nz,insert_pause
            jr      testloop       ; Loop to next element in song 
 
 
 
playnote: 
;load data (hl)  l=length, h=pitch 
tempo_smc: 
            ld      a,2                             ;eg. 4 - wow many times through the loop (sort of tempo multipler)
            ld      (smc_length+1),a                ;setup the length of loop where it's reset
            ld      (noteroll),a ;noteroll          ;and initially
 
            ld      (notelength),hl

            ld      e,1                             ;make sure there is no errant "previous note" that matches the one playing 
 
jumpbackpoint:                          ;come back here to setup d with the pitch of the note 
 
            ld      hl,noteroll         ;noteroll is a X-to-0 counter that determines how many times 
            dec     (hl)                ;it goes through the cycle (i.e. the length in the l register) 
            jr      nz,skipcounterdown  ; 
smc_length:
            ld      (hl),0              ;reset noteroll to it's value (equates to tempo) (will have been setup previously) 
 
 
            ld      hl,notelength       ;notelength is length (see also noteroll, though)
            dec     (hl)                ;decrease it until it's zero
            ret     z                   ; 


skipcounterdown:
 
            ld      hl,notepitch        ;d is given the required pitch 
            ld      d,(hl)


 
 
generateanote:   ;generate a note 
                 ;pitch is held in register d
                 ;but first check is it a "new" note ?
            ld      a,d
            cp      e                   ;e holds previous note 
            jr      z,sameoldnote       ;if it is the same, then we don't need to change counters etc
newnotebeingplayed:
            xor     a                   ;clear carry flag) 
            ld      a,d 
            ld      e,a                 ;store that note for comparisson next time 
            ld      (smc_ug2+1),a 
            rra                         ;a=d/2 
            ld      c,a                 ;c is used to keep counter temporarily

sameoldnote:                            ;enter here if if is the same note as before 
            ld      a,c                 ;restore counter 


            inc     a                   ;inc counter 
            ld      b,a                 ;load it into b, for a djnz loop 
killsometime:
            nop                          ;4 tstates,one byte
            cp      (hl)                 ;7 tstates, one byte, no purpose - just killing some time 
            cp      (hl)                 ;7 tstates 
            cp      (hl)                 ;7 tstates 
            cp      (hl)                 ;7 tstates
            nop                          ;4 tstates
 
            ;cp      (ix+1)               ;19 T states in THREE BYTES 


            djnz    killsometime

musiccol2:  ld      a,16                 ;will determine border colour as well.  16+colour.  17=blue
            out     (254),a

            ld      a,d                  ;get the pitch
            sub     c                    ;take away the counter
            inc     a                    ;add 1 to stop it ever being zero
            ld      b,a                  ;put the result into b

killsometime2:
            nop                          ;4 tstates,one byte
            cp      (hl)                 ;7 tstates, one byte, no purpose - just killing some time
            cp      (hl)                 ;7 tstates
            cp      (hl)                 ;7 tstates
            cp      (hl)                 ;7 tstates
            nop                          ;4 tstates    TOTAL = 36 T-states in 5 bytes

            ;cp      (ix+1)               ;19 T states in THREE BYTES
            ;                             ;+
            ;cp      (hl)                 ;7 T-states
            ;cp      (hl)                 ;+7 T-states
            ;nop                          ;+4=18 T states in THREE BYTES
                                          ;
                                          ; TOTAL = 37 T-states in SIX BYTES



            djnz    killsometime2

musiccol1:  ld      a,1                  ;also determine border colour.  0+colour .  6=yellow  1=blue.
            out     (254),a

                                         ;now we'll change the pulse width by changing a/c
            ld      a,c

smc_ug1:                                 ;this is smc modified to change whether pulse width is increasing or decreasing
            add     a,255                ;either add or subtract 1  (subtract 1=adding 255)
            ld      c,a                  ;update c

            jp      z,changedirection
smc_ug2:
            ld      a,0                  ;this is smc modified when a new note is played
            cp      c
            jp      z,changedirection
            jp      jumpbackpoint

changedirection:
            ld      a,(smc_ug1+1)         ;uses twos complement to turn 1 into 255 and vice versa
            cpl                           ;
            inc     a                     ;
            ld      (smc_ug1+1),a         ;
            jp      jumpbackpoint



; these variables are set up used to count the note length, and wavelength
noteroll:   db      0
notelength: db      1
notepitch:  db      253 ; note length and pitch
songpointer: dw     0



;SONGDATA (Auld Lang Syne)
musicdata:

jingle4:    db    fs3c/3,fs3
            db    fs3c/3,fs3
            db    gs3c/3,gs3
            db    gs3c/3,gs3
            db    ds3c/3,ds3
            db    ds3c/3,ds3
            db    fs3c/3*2,fs3

            db    fs3c/3,fs3
            db    fs3c/3,fs3
            db    gs3c/3,gs3
            db    gs3c/3,gs3
            db    ds3c/3,ds3
            db    ds3c/3,ds3
            db    fs3c/3*2,fs3

            db    fs3c/3,fs3
            db    fs3c/3,fs3
            db    gs3c/3,gs3
            db    gs3c/3,gs3
            db    b3c/3,b3
            db    b3c/3,b3
            db    as3c/3*2,as3

            db    as3c/3*2,as3
            db    gs3c/3*2,gs3
            db    fs3c/3*2,fs3
            db    e3c/3*2,e3

            db    e3c/12,e3
            db    gs3c/12,gs3
            db    b3c/12,b3
            db    e3c/12,e3
            db    gs3c/12,gs3
            db    b3c/12,b3
            db    e4c/12,e4
            db    gs3c/12,gs3
            db    b3c/12,b3
            db    e4c/12,e4
            db    gs3c/12,gs3
            db    b3c/12,b3
            db    e4c/8,e4

            db    0,0


jingle3:
	    db	a3c/4,a3
            db  fs3c/4,fs3
            db  d3c/2,d3
            db	d3c/2,d3
            db  d3c/4,d3
            db  e3c/4,e3
            db  fs3c/4,fs3
            db  g3c/4,g3
            db  a3c/2,a3
            db  a3c/2,a3
            db  a3c/2,a3
            db  fs3c/2,fs3
            db	c3/32,c3
            db	cs3/32,cs3
 	    db	d3/32,d3
            db	cs3/32,cs3
     	    db	d3/32,d3
            db	ds3/32,ds3
            db	d3/32,d3
            db	ds3/32,ds3
            db	e3/32,e3
            db	ds3/32,ds3
            db	e3/32,e3
            db	f3/32,f3
            db	e3/32,e3
            db	f3/32,f3
            db	fs3/32,fs3
            db	f3/32,f3
            db	fs3/32,fs3
            db	g3/32,g3
            db	fs3/32,fs3
            db	g3/32,g3
            db	gs3/32,gs3
            db	g3/32,g3
            db	gs3/32,gs3
            db	a3/32,a3
            db	gs3/32,gs3
            db	a3/32,a3
            db	as3/32,as3
            db	a3/32,a3
            db	as3/32,as3
            db	b3/32,b3
            db	as3/32,as3
            db	b3/32,b3
            db	c4/32,c4
            db	b3/32,b3
            db	c4/32,c4
            db	cs4/32,cs4
            db	c4/32,c4
            db	cs4/32,cs4
            db	d4/8,d4

            db 0,0



jingle2:
             db	d3c/3,d3
             db fs3c/3,fs3
             db	a3c/3,a3
             db	d3c/3,d3
             db fs3c/3,fs3
             db	a3c/3,a3

             db	ds3c/3,ds3
             db g3c/3,g3
             db	as3c/3,as3
             db	ds3c/3,ds3
             db g3c/3,g3
             db	as3c/3,as3

             db	d3c/3,d3
             db fs3c/3,fs3
             db	a3c/3,a3
             db	d3c/3,d3
             db fs3c/3,fs3
             db	a3c/3,a3

 	db	c3/32,c3
 	db	cs3/32,cs3
 	db	d3/32,d3
 	db	ds3/32,ds3
 	db	e3/32,e3
 	db	f3/32,f3
 	db	fs3/32,fs3
 	db	g3/32,g3
 	db	gs3/32,gs3
 	db	a3/32,a3
 	db	as3/32,as3
 	db	b3/32,b3
 	db	c4/32,c4
 	db	cs4/32,cs4
 	db	d4/32,d4

	db	ds4/32,ds4
 	db	d4/32,d4
	db	cs4/32,cs4
 	db	d4/32,d4
	db	ds4/32,ds4
 	db	d4/32,d4
 	db	cs4/32,cs4
 	db	d4/32,d4
	db	ds4/32,ds4
 	db	d4/32,d4
 	db	cs4/32,cs4
 	db	d4/32,d4
	db	ds4/32,ds4
 	db	d4/32,d4
 	db	cs4/32,cs4
 	db	d4/8,d4


        db 0,0

jingle1:                  ;
;chord1: Dmajor
             db	d3c/3,d3
             db fs3c/3,fs3
             db	a3c/3,a3
             db d4c*2/3,d4
             db d4c/3,d4
             db a3c*2/3,a3
             db a3c/3,a3
             db fs3c/3,fs3
             db a3c/3,a3
             db fs3c/3,fs3
             db	d3c,d3
             db d3/32,d3
             db d4/32,d4
             db d3/32,d3
             db d4/32,d4
             db d3/32,d3
             db d4/32,d4
             db d3/32,d3
             db d4/32,d4
             db d3/32,d3

             db 0,0

             db  0        ;end of song

;            NB  data format for rest will be LENGTH,0 - length is arbritrary, rather than useful!

exitjingle:
             db d3c/3,d3
             db fs3c/3,fs3
	     db	a3c/3,a3
             db d3c/3,d3
             db g3c/3,g3
	     db	b3c/3,b3

             db fs3c/3,fs3
	     db	a3c/3,a3
             db d4c/3,d4


             db d3c/8,d3
	     db a3c/16,a3
             db d4c/16,d4
             db d3c/8,d3
	     db a3c/16,a3
             db d4c/16,d4
             db d3c/8,d3
	     db a3c/16,a3
             db d4c/16,d4
	     db 0,0

startjingle:
             db	f4c,f4+1
             db d4c/3,d4
             db	a3c/3,a3
             db f3c/3,f3

             db d3c*2,d3
             db c3c,c3
 	     db a3c,a3

;chord2: Dm7b5
	     db	f3c,f3
             db d4c/8,d4
             db	a3c/8 ,a3
             db f3c/8,f3
             db d4c/8,d4
             db	a3c/8 ,a3
             db f3c/8,f3
             db d4c/8,d4
             db	a3c/8,a3
             db f3c/10,f3
             db 0,0

congratsjingle:
             db d3c/2,d3
             db e3c/2,e3
             db fs3c/2,fs3
             db g3c/1,g3
             db d3c*3/2,d3
             db g3c/2,g3
             db fs3c/2,fs3
             db g3c/2,g3

             db a3c/1,a3
             db e3c*3/2,e3

             db e3c/2,e3
             db fs3c/2,fs3
             db g3c/2,g3
             db b3c/2,b3
             db a3c/2,a3
             db a3c/2,a3

             db g3c/2,g3
             db g3c/2,g3

             db fs3c/2,fs3
             db e3c/2,e3
             db fs3c/2,fs3
             db g3c/2,g3

             db g3c/16,g3
             db d3c/16,d3
             db g3c/16,g3
             db d3c/16,d3
             db g3c/16,g3
             db d3c/16,d3
             db g3c/16,g3
             db d3c/16,d3
             db g3c/16,g3
             db d3c/16,d3
             db g3c/16,g3
             db d3c/16,d3


             db g3c/16,g3
             db d3c/16,d3
             db a3c/16,a3
             db d3c/16,d3
	     db a3c/16,a3
             db d3c/16,d3
	     db b3c/16,b3
             db d3c/16,d3
	     db b3c/16,b3
             db d3c/16,d3
    	     db c3c/16,c3
             db d3c/16,d3
	     db c3c/16,c3
             db d3c/16,d3

             db g3c/16,g3
             db d3c/16,d3
             db g3c/16,g3
             db d3c/16,d3


             db d3c/16,d3
             db d3c/16,d3

             db ds3c/16,ds3
             db d3c/16,d3


             db e3c/16,e3
             db d3c/16,d3

             db f3c/16,f3
             db d3c/16,d3

             db fs3c/16,fs3
             db d3c/16,d3


             db g3c/16,g3
             db d3c/16,d3

             db g3c*2,g3
             db 0,0

;opening theme
openingthemejingle:
	     db	f4c,f4
             db d4c,d4
             db	a3c,a3
             db f3c,f3

             db d3c*2/3,d3
             db e3c*2/3,e3
             db f3c*2/3,f3

 	     db a3c,a3
             db f3c,f3
;chord2: Dm7b5
	     db	c4c,c4
             db gs3c,gs3
             db	f3c,f3
             db d3c,d3

             db d3c*2/3,d3
             db e3c*2/3,e3
             db f3c*2/3,f3

 	     db gs3c*2,gs3
             ;db gs3c,gs3

;chord1: Dm
	     db	f4c/2,f4
             db	a4c/2,a4+1
             db d4c/2,d4
             db	a4c/2,a4+1
             db	a3c/2,a3
             db	a4c/2,a4+1
             db f3c/2,f3
             db	a4c/2,a4+1

             db d3c*2/3,d3
             db e3c*2/3,e3
             db f3c*2/3,f3

             db d3c/4,d3
             db e3c/4,e3
             db f3c/4,f3
             db g3c/4,g3

 	     db a3c/2,a3
	     db f3c/2,f3

;chord2: Dm7b5
             db	c4c/2,c4
             db gs3c/2,gs3
 	     db	f3c/2,f3
             db d3c/2,d3

             db d4c/2,d4
             db gs3c/2,gs3
 	     db	f3c/2,f3
             db d3c/2,d3


             db gs3c*2/3,gs3
             db b3c*2/3,b3
             db c4c*2/3,c4

            db gs3c,gs3
            db gs4c/4,gs4
            db f4c/4,f4
            db d4c/4,d4
            db c4c/4,c4

;ab chord 1
	    db ds3c/4,ds3
            db gs3c/4,gs3
            db c4c/4,c4
	    db ds3c/4,ds3

	    db gs3c/4,gs3
            db c4c/4,c4
	    db ds3c/4,ds3
	    db gs3c/4,gs3

            db c4c/4,c4
	    db ds3c/4,ds3
	    db gs3c/4,gs3
            db c4c/4,c4

            db ds3c/4,ds3
	    db ds4c/4,ds4
            db ds3c/4,ds3
	    db c3c/4,c3
;g chords 1
	    db d3c/4,d3
	    db g3c/4,g3
            db b3c/4,b3
	    db d3c/4,d3

	    db g3c/4,g3
            db b3c/4,b3
	    db d3c/4,d3
	    db g3c/4,g3

            db b3c/4,b3
	    db d3c/4,d3
	    db g3c/4,g3
            db b3c/4,b3

            db d3c/4,d3
	    db d4c/4,d4
            db d3c/4,d3
	    db b3c/4,b3

;ab chord 2
	    db ds3c/4,ds3
	    db gs3c/4,gs3
            db c4c/4,c4
	    db ds3c/4,ds3

	    db gs3c/4,gs3
            db d4c/4,d4
	    db ds3c/4,ds3
	    db gs3c/4,gs3

            db ds4c/4,ds4
	    db ds3c/4,ds3
	    db gs3c/4,gs3
            db c4c/4,c4

            db ds3c/4,ds3
	    db ds4c/4,ds4
            db ds3c/4,ds3
	    db c3c/4,c3
;g chords 2
	    db d3c/4,d3
            db g3c/4,g3
            db b3c/4,b3
	    db d3c/4,d3

	    db g3c/4,g3
            db c4c/4,c4
	    db d3c/4,d3
	    db g3c/4,g3

            db d4c/4,d4
	    db d3c/4,d3
	    db g3c/4,g3
            db b3c/4,b3

            db d3c/4,d3
	    db d4c/4,d4
            db d3c/4,d3
	    db b3c/4,b3

;ab chord 3 -
	    db ds3c/4,ds3
            db gs3c/4,gs3
            db g4c/4,g4+1	;
	    db ds3c/4,ds3

	    db gs3c/4,gs3
            db f4c/4,f4   ;
	    db ds3c/4,ds3
	    db gs3c/4,gs3

            db ds4c/4,ds4 ;
	    db ds3c/4,ds3
	    db gs3c/4,gs3
            db c4c/4,c4 ;

            db ds3c/4,ds3
	    db ds4c/4,ds4
            db ds3c/4,ds3
	    db c3c/4,c3
;g chords 3
	    db d3c/4,d3
	    db g3c/4,g3
            db f4c/4,f4+1 ;
	    db d3c/4,d3

	    db g3c/4,g3
            db d4c/4,d4 ;
	    db d3c/4,d3
	    db g3c/4,g3

            db c4c/4,c4 ;
	    db d3c/4,d3
	    db g3c/4,g3
            db b3c/4,b3 ;

            db d3c/4,d3
	    db d4c/4,d4
            db d3c/4,d3
	    db b3c/4,b3

;ab chord 4
	    db ds3c/4,ds3
	    db gs3c/4,gs3
            db c4c/4,c4
	    db ds3c/4,ds3

	    db gs3c/4,gs3
            db d4c/4,d4
	    db ds3c/4,ds3
	    db gs3c/4,gs3

            db ds4c/4,ds4
	    db ds3c/4,ds3
	    db gs3c/4,gs3
            db c4c/4,c4

            db ds3c/4,ds3
	    db ds4c/4,ds4
            db ds3c/4,ds3
	    db c3c/4,c3
;b aug chords 4
            db f4c/4,f4
	    db d4c/4,d4
            db b3c/4,b3
	    db gs3c/4,gs3

	    db d4c/4,d4
            db b3c/4,b3
	    db gs3c/4,gs3
            db f3c/4,f3

            db b3c/4,b3
	    db gs3c/4,gs3
            db f3c/4,f3
	    db d3c/4,d3

;            db gs3c/4,gs3            ;
;			db f3c/4,f3
;            db d3c/4,d3

            db c3c/8,c3
	    db cs3c/8,cs3
            db d3c/8,d3
            db ds3c/8,ds3
            db d3c/8,d3
	    db cs3c/8,cs3
            db c3c/8,c3
            db c3c/8,c3
	    db cs3c/8,cs3
            db d3c/8,d3
            db ds3c/8,ds3
            db d3c/8,d3



;dmchord
	    db d3c*3,d3
            db f3c/4,f3
	    db a3c/4,a3
	    db c4c/4,c4
            db d4c/4,d4

	    db d3c*3,d3
            db f3c/4,f3
	    db a3c/4,a3
	    db c4c/4,c4
            db d4c/4,d4

	    db d3c*3,d3
            db f3c/4,f3
	    db a3c/4,a3
	    db c4c/4,c4
            db d4c/4,d4

	    db d3c*2,d3

            db cs3c/8,cs3
	    db c3c/8,c3
   	    db cs3c/8,cs3
            db d3c/8,d3
            db ds3c/8,ds3
            db e3c/8,e3
            db f3c/8,f3
            db fs3c/8,fs3
	    db g3c/8,g3
	    db gs3c/8,gs3
            db a3c/8,a3
            db as3c/8,as3

	    db b3c/8,b3
	    db c4c/8,c4
            db cs4c/8,cs4
            db d4c/8,d4
            db f4c/8,f4
            db g4c/8,g4
 	    db 0,0

;Define notes
c3              equ      253    ;c# [concert tunings, 440hz]  ish
cs3             equ      240    ;d
db3             equ      240    ;d
d3              equ      226    ;d#   so jingles are ACTUALLY in d#
ds3             equ      212    ;e
eb3             equ      212    ;e
e3              equ      200    ;f
f3              equ      188    ;f#
fs3             equ      177    ;g
gb3             equ      177    ;g
g3              equ      166    ;g#
gs3             equ      156    ;a
ab3             equ      156    ;a 
a3              equ      147    ;a# 
as3             equ      137    ;b 
bb3             equ      137    ;b 
b3              equ      129    ;C 
c4              equ      122    ;C# 
cs4             equ      114    ;D 
db4             equ      114    ;D 
d4              equ      108    ;D#
ds4             equ      101    ;E
eb4             equ      101    ;E
e4              equ      95     ;F 
f4              equ      88     ;F# 
fs4             equ      83     ;G
gb4             equ      83     ;G 
g4              equ      77     ;G# 
gs4             equ      73     ;A
ab4             equ      73     ;A 
a4              equ      68    ;A#
as4             equ      63    ;B 
bb4             equ      63    ;B 
        
;define note lengths (of crotchets)   - different for each
c3c             equ      60    ;c# 
cs3c            equ      63    ;d 
db3c            equ      63    ;d 
d3c             equ      67    ;d# 
ds3c            equ      72    ;e 
eb3c            equ      72    ;e
e3c             equ      76    ;f 
f3c             equ      80    ;f# 
fs3c            equ      85    ;g 
gb3c            equ      85    ;g 
g3c             equ      90    ;g#
gs3c            equ      96    ;a 
ab3c            equ      96    ;a 
a3c             equ      101    ;a# 
as3c            equ      108    ;b 
bb3c            equ      108    ;b 
b3c             equ      114    ;C 
c4c             equ      120    ;C# 
cs4c            equ      128    ;D 
db4c            equ      128    ;D
d4c             equ      135    ;D#
ds4c            equ      143    ;E 
eb4c            equ      143    ;E 
e4c             equ      151    ;F 
f4c             equ      162    ;F# 
fs4c            equ      171    ;G
gb4c            equ      171    ;G 
g4c             equ      183    ;G# 
gs4c            equ      192    ;A 
ab4c            equ      192    ;A
a4c             equ      204    ;A# 
as4c            equ      218    ;B 
bb4c            equ      218    ;B 
 
d3q          	equ 34 
e3q          	equ 38 
f3q          	equ 40
g3q          	equ 45
a3q          	equ 51




END_OF_GAME:                                      ; loading screen stored here


                                      ; 97EE hex
            org         SCRATCHATTR
            call        set_up_the_screen           ;3 bytes
            ld          hl,hackmessage              ;3 bytes
hackloop:   ld          a,(hl)                      ;2 bytes?
            cp          255                         ;2 byte
            jr          z,leavehack                 ;2 bytes
            rst         10h                         ;1 byte
            inc         hl                          ;1 byte
            jr          hackloop                    ;2 bytes
leavehack:
             jp          32768                       ;3 bytes
hackmessage:
            defb        22,0,0                      ;3 bytes
            defb        17,0,16,4,"HELLO HACKER...",13
            defb        "You clearly have the skills of",13,"David Lightman in War Games!",13,"Whilst I can't offer you a game of thermonulear war (or chess)",13
            defb        "here's a little secret you can'tfind elsewhere. During the game you can press"
            defb        " 2 & 5 and this",13,"will open a secret part of the",13,"maze which illustrates the short-"
            defb        "comings of the 3D engine. It's",13,"off the bottom of the map, and",13,"has white panels on corners and open spaces that the game can't render correctly."
            defb        " There is also the cheat 2&3 together, that'll set your score close to the",13,"target, and 5 on the menu that",13,"slows the minigames down.",13,"4&5 together quit a game from",13,"the maze."
            defb        13,"Have fun. Andy Jenkinson"
            defb        255                         ;0 bytes


            end         32768



;-------------------------------
;debug routine used to print the snake stack
;--------------------------------
debug:
                  ld      a,2              ; Printing to the Upper screen
                  call    5633             ; Open channel

            ld    b,0 ; counter
debugloop:
            ld    a,22
            rst   16
            ld    a,b
            inc   a
            rst   16
            ld    a,25
            rst   16
            ld    hl,snakedirection
            ld    a,b
            ld    e,a
            rl    e           ;double e
            ld    d,0
            add   hl,de
            push  hl
            call  hexout_hl_contents
            ld    a,32
            rst   16
            pop   hl
            inc   hl
            call  hexout_hl_contents
            inc   b
            ld    a,11
            cp    b
            jr    nz,debugloop
waitforp:
            ld bc,$bffe         ; keyboard row ENTER
            in a,(c)            ; see what keys are pressed.
            rra                 ; outermost bit = key ENTER.
            jr  nc, waitforp
waitforp2:
            ld bc,$bffe         ; keyboard row ENTER
            in a,(c)            ; see what keys are pressed.
            rra                 ; outermost bit = key ENTER.
            jr  c,waitforp2
            ret

hexout_hl_contents:      ; DOES print the contects of HL in hex
            push  hl

          ;  ld   hl,65000 ; just for testing
          ;  ld   (hl),$c9

            ld    a,(hl)
;print A in HEX
            push  af
            or    a
            and   %11110000
            rrca
            rrca
            rrca
            rrca

            ld    e,a
            ld    d,0
            ld    hl,hexstring
            add   hl,de
            ld    a,(hl)
            rst   16
            pop   af
            or    a ;clear carry
            and   %1111

            ld    e,a
            ld    d,0
            ld    hl,hexstring
            add   hl,de
            ld    a,(hl)
            rst   16
            pop   hl
            ret

hexstring:   defb "0123456789ABCDEF"

